/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.util;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.util.BytesUtil;

public class CamelliaKey {
    static final byte[] SBOX1 = new byte[]{112, -126, 44, -20, -77, 39, -64, -27, -28, -123, 87, 53, -22, 12, -82, 65, 35, -17, 107, -109, 69, 25, -91, 33, -19, 14, 79, 78, 29, 101, -110, -67, -122, -72, -81, -113, 124, -21, 31, -50, 62, 48, -36, 95, 94, -59, 11, 26, -90, -31, 57, -54, -43, 71, 93, 61, -39, 1, 90, -42, 81, 86, 108, 77, -117, 13, -102, 102, -5, -52, -80, 45, 116, 18, 43, 32, -16, -79, -124, -103, -33, 76, -53, -62, 52, 126, 118, 5, 109, -73, -87, 49, -47, 23, 4, -41, 20, 88, 58, 97, -34, 27, 17, 28, 50, 15, -100, 22, 83, 24, -14, 34, -2, 68, -49, -78, -61, -75, 122, -111, 36, 8, -24, -88, 96, -4, 105, 80, -86, -48, -96, 125, -95, -119, 98, -105, 84, 91, 30, -107, -32, -1, 100, -46, 16, -60, 0, 72, -93, -9, 117, -37, -118, 3, -26, -38, 9, 63, -35, -108, -121, 92, -125, 2, -51, 74, -112, 51, 115, 103, -10, -13, -99, 127, -65, -30, 82, -101, -40, 38, -56, 55, -58, 59, -127, -106, 111, 75, 19, -66, 99, 46, -23, 121, -89, -116, -97, 110, -68, -114, 41, -11, -7, -74, 47, -3, -76, 89, 120, -104, 6, 106, -25, 70, 113, -70, -44, 37, -85, 66, -120, -94, -115, -6, 114, 7, -71, 85, -8, -18, -84, 10, 54, 73, 42, 104, 60, 56, -15, -92, 64, 40, -45, 123, -69, -55, 67, -63, 21, -29, -83, -12, 119, -57, -128, -98};
    private static final int[] SIGMA = new int[]{-1600231809, 1003262091, -1233459112, 1286239154, -957401297, -380665154, 1426019237, -237801700, 283453434, -563598051, -1336506174, -1276722691};
    protected int[] subkey = new int[96];
    protected int[] kw = new int[8];
    protected int[] ke = new int[12];
    private int keySize;

    public CamelliaKey(byte[] key, boolean isEncrypt) {
        this.init(key, isEncrypt);
    }

    private static int rightRotate(int x, int s2) {
        return (x >>> s2) + (x << 32 - s2);
    }

    private static int leftRotate(int x, int s2) {
        return (x << s2) + (x >>> 32 - s2);
    }

    private static void roldq(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[0 + ooff] = ki[0 + ioff] << rot | ki[1 + ioff] >>> 32 - rot;
        ko[1 + ooff] = ki[1 + ioff] << rot | ki[2 + ioff] >>> 32 - rot;
        ko[2 + ooff] = ki[2 + ioff] << rot | ki[3 + ioff] >>> 32 - rot;
        ko[3 + ooff] = ki[3 + ioff] << rot | ki[0 + ioff] >>> 32 - rot;
        ki[0 + ioff] = ko[0 + ooff];
        ki[1 + ioff] = ko[1 + ooff];
        ki[2 + ioff] = ko[2 + ooff];
        ki[3 + ioff] = ko[3 + ooff];
    }

    private static void decroldq(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[2 + ooff] = ki[0 + ioff] << rot | ki[1 + ioff] >>> 32 - rot;
        ko[3 + ooff] = ki[1 + ioff] << rot | ki[2 + ioff] >>> 32 - rot;
        ko[0 + ooff] = ki[2 + ioff] << rot | ki[3 + ioff] >>> 32 - rot;
        ko[1 + ooff] = ki[3 + ioff] << rot | ki[0 + ioff] >>> 32 - rot;
        ki[0 + ioff] = ko[2 + ooff];
        ki[1 + ioff] = ko[3 + ooff];
        ki[2 + ioff] = ko[0 + ooff];
        ki[3 + ioff] = ko[1 + ooff];
    }

    private static void roldqo32(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[0 + ooff] = ki[1 + ioff] << rot - 32 | ki[2 + ioff] >>> 64 - rot;
        ko[1 + ooff] = ki[2 + ioff] << rot - 32 | ki[3 + ioff] >>> 64 - rot;
        ko[2 + ooff] = ki[3 + ioff] << rot - 32 | ki[0 + ioff] >>> 64 - rot;
        ko[3 + ooff] = ki[0 + ioff] << rot - 32 | ki[1 + ioff] >>> 64 - rot;
        ki[0 + ioff] = ko[0 + ooff];
        ki[1 + ioff] = ko[1 + ooff];
        ki[2 + ioff] = ko[2 + ooff];
        ki[3 + ioff] = ko[3 + ooff];
    }

    private static void decroldqo32(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[2 + ooff] = ki[1 + ioff] << rot - 32 | ki[2 + ioff] >>> 64 - rot;
        ko[3 + ooff] = ki[2 + ioff] << rot - 32 | ki[3 + ioff] >>> 64 - rot;
        ko[0 + ooff] = ki[3 + ioff] << rot - 32 | ki[0 + ioff] >>> 64 - rot;
        ko[1 + ooff] = ki[0 + ioff] << rot - 32 | ki[1 + ioff] >>> 64 - rot;
        ki[0 + ioff] = ko[2 + ooff];
        ki[1 + ioff] = ko[3 + ooff];
        ki[2 + ioff] = ko[0 + ooff];
        ki[3 + ioff] = ko[1 + ooff];
    }

    protected boolean is128() {
        return this.keySize == 16;
    }

    private byte lRot8(byte v, int rot) {
        return (byte)(v << rot | (v & 0xFF) >>> 8 - rot);
    }

    private int sbox2(int x) {
        return this.lRot8(SBOX1[x], 1) & 0xFF;
    }

    private int sbox3(int x) {
        return this.lRot8(SBOX1[x], 7) & 0xFF;
    }

    private int sbox4(int x) {
        return SBOX1[this.lRot8((byte)x, 1) & 0xFF] & 0xFF;
    }

    protected void fls(int[] s2, int[] fkey, int keyoff) {
        s2[1] = s2[1] ^ CamelliaKey.leftRotate(s2[0] & fkey[0 + keyoff], 1);
        s2[0] = s2[0] ^ (fkey[1 + keyoff] | s2[1]);
        s2[2] = s2[2] ^ (fkey[3 + keyoff] | s2[3]);
        s2[3] = s2[3] ^ CamelliaKey.leftRotate(fkey[2 + keyoff] & s2[2], 1);
    }

    protected void f2(int[] s2, int[] skey, int keyoff) {
        int t1 = s2[0] ^ skey[0 + keyoff];
        int u = this.sbox4(t1 & 0xFF);
        u |= this.sbox3(t1 >>> 8 & 0xFF) << 8;
        u |= this.sbox2(t1 >>> 16 & 0xFF) << 16;
        u |= (SBOX1[t1 >>> 24 & 0xFF] & 0xFF) << 24;
        int t2 = s2[1] ^ skey[1 + keyoff];
        int v = SBOX1[t2 & 0xFF] & 0xFF;
        v |= this.sbox4(t2 >>> 8 & 0xFF) << 8;
        v |= this.sbox3(t2 >>> 16 & 0xFF) << 16;
        v |= this.sbox2(t2 >>> 24 & 0xFF) << 24;
        v = CamelliaKey.leftRotate(v, 8);
        u ^= v;
        v = CamelliaKey.leftRotate(v, 8) ^ u;
        u = CamelliaKey.rightRotate(u, 8) ^ v;
        s2[2] = s2[2] ^ (CamelliaKey.leftRotate(v, 16) ^ u);
        s2[3] = s2[3] ^ CamelliaKey.leftRotate(u, 8);
        t1 = s2[2] ^ skey[2 + keyoff];
        u = this.sbox4(t1 & 0xFF);
        u |= this.sbox3(t1 >>> 8 & 0xFF) << 8;
        u |= this.sbox2(t1 >>> 16 & 0xFF) << 16;
        u |= (SBOX1[t1 >>> 24 & 0xFF] & 0xFF) << 24;
        t2 = s2[3] ^ skey[3 + keyoff];
        v = SBOX1[t2 & 0xFF] & 0xFF;
        v |= this.sbox4(t2 >>> 8 & 0xFF) << 8;
        v |= this.sbox3(t2 >>> 16 & 0xFF) << 16;
        v |= this.sbox2(t2 >>> 24 & 0xFF) << 24;
        v = CamelliaKey.leftRotate(v, 8);
        u ^= v;
        v = CamelliaKey.leftRotate(v, 8) ^ u;
        u = CamelliaKey.rightRotate(u, 8) ^ v;
        s2[0] = s2[0] ^ (CamelliaKey.leftRotate(v, 16) ^ u);
        s2[1] = s2[1] ^ CamelliaKey.leftRotate(u, 8);
    }

    private void init(byte[] key, boolean isEncrypt) {
        int i;
        this.keySize = key.length;
        int[] k = new int[8];
        int[] ka = new int[4];
        int[] kb = new int[4];
        int[] t = new int[4];
        switch (key.length) {
            case 16: {
                k[0] = BytesUtil.bytes2int(key, 0, true);
                k[1] = BytesUtil.bytes2int(key, 4, true);
                k[2] = BytesUtil.bytes2int(key, 8, true);
                k[3] = BytesUtil.bytes2int(key, 12, true);
                k[7] = 0;
                k[6] = 0;
                k[5] = 0;
                k[4] = 0;
                break;
            }
            case 24: {
                k[0] = BytesUtil.bytes2int(key, 0, true);
                k[1] = BytesUtil.bytes2int(key, 4, true);
                k[2] = BytesUtil.bytes2int(key, 8, true);
                k[3] = BytesUtil.bytes2int(key, 12, true);
                k[4] = BytesUtil.bytes2int(key, 16, true);
                k[5] = BytesUtil.bytes2int(key, 20, true);
                k[6] = ~k[4];
                k[7] = ~k[5];
                break;
            }
            case 32: {
                k[0] = BytesUtil.bytes2int(key, 0, true);
                k[1] = BytesUtil.bytes2int(key, 4, true);
                k[2] = BytesUtil.bytes2int(key, 8, true);
                k[3] = BytesUtil.bytes2int(key, 12, true);
                k[4] = BytesUtil.bytes2int(key, 16, true);
                k[5] = BytesUtil.bytes2int(key, 20, true);
                k[6] = BytesUtil.bytes2int(key, 24, true);
                k[7] = BytesUtil.bytes2int(key, 28, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid key size, only support 16/24/32 bytes");
            }
        }
        for (i = 0; i < 4; ++i) {
            ka[i] = k[i] ^ k[i + 4];
        }
        this.f2(ka, SIGMA, 0);
        for (i = 0; i < 4; ++i) {
            int n = i;
            ka[n] = ka[n] ^ k[i];
        }
        this.f2(ka, SIGMA, 4);
        if (this.keySize == 16) {
            if (isEncrypt) {
                this.kw[0] = k[0];
                this.kw[1] = k[1];
                this.kw[2] = k[2];
                this.kw[3] = k[3];
                CamelliaKey.roldq(15, k, 0, this.subkey, 4);
                CamelliaKey.roldq(30, k, 0, this.subkey, 12);
                CamelliaKey.roldq(15, k, 0, t, 0);
                this.subkey[18] = t[2];
                this.subkey[19] = t[3];
                CamelliaKey.roldq(17, k, 0, this.ke, 4);
                CamelliaKey.roldq(17, k, 0, this.subkey, 24);
                CamelliaKey.roldq(17, k, 0, this.subkey, 32);
                this.subkey[0] = ka[0];
                this.subkey[1] = ka[1];
                this.subkey[2] = ka[2];
                this.subkey[3] = ka[3];
                CamelliaKey.roldq(15, ka, 0, this.subkey, 8);
                CamelliaKey.roldq(15, ka, 0, this.ke, 0);
                CamelliaKey.roldq(15, ka, 0, t, 0);
                this.subkey[16] = t[0];
                this.subkey[17] = t[1];
                CamelliaKey.roldq(15, ka, 0, this.subkey, 20);
                CamelliaKey.roldqo32(34, ka, 0, this.subkey, 28);
                CamelliaKey.roldq(17, ka, 0, this.kw, 4);
            } else {
                this.kw[4] = k[0];
                this.kw[5] = k[1];
                this.kw[6] = k[2];
                this.kw[7] = k[3];
                CamelliaKey.decroldq(15, k, 0, this.subkey, 28);
                CamelliaKey.decroldq(30, k, 0, this.subkey, 20);
                CamelliaKey.decroldq(15, k, 0, t, 0);
                this.subkey[16] = t[0];
                this.subkey[17] = t[1];
                CamelliaKey.decroldq(17, k, 0, this.ke, 0);
                CamelliaKey.decroldq(17, k, 0, this.subkey, 8);
                CamelliaKey.decroldq(17, k, 0, this.subkey, 0);
                this.subkey[34] = ka[0];
                this.subkey[35] = ka[1];
                this.subkey[32] = ka[2];
                this.subkey[33] = ka[3];
                CamelliaKey.decroldq(15, ka, 0, this.subkey, 24);
                CamelliaKey.decroldq(15, ka, 0, this.ke, 4);
                CamelliaKey.decroldq(15, ka, 0, t, 0);
                this.subkey[18] = t[2];
                this.subkey[19] = t[3];
                CamelliaKey.decroldq(15, ka, 0, this.subkey, 12);
                CamelliaKey.decroldqo32(34, ka, 0, this.subkey, 4);
                CamelliaKey.roldq(17, ka, 0, this.kw, 0);
            }
        } else {
            for (i = 0; i < 4; ++i) {
                kb[i] = ka[i] ^ k[i + 4];
            }
            this.f2(kb, SIGMA, 8);
            if (isEncrypt) {
                this.kw[0] = k[0];
                this.kw[1] = k[1];
                this.kw[2] = k[2];
                this.kw[3] = k[3];
                CamelliaKey.roldqo32(45, k, 0, this.subkey, 16);
                CamelliaKey.roldq(15, k, 0, this.ke, 4);
                CamelliaKey.roldq(17, k, 0, this.subkey, 32);
                CamelliaKey.roldqo32(34, k, 0, this.subkey, 44);
                CamelliaKey.roldq(15, k, 4, this.subkey, 4);
                CamelliaKey.roldq(15, k, 4, this.ke, 0);
                CamelliaKey.roldq(30, k, 4, this.subkey, 24);
                CamelliaKey.roldqo32(34, k, 4, this.subkey, 36);
                CamelliaKey.roldq(15, ka, 0, this.subkey, 8);
                CamelliaKey.roldq(30, ka, 0, this.subkey, 20);
                this.ke[8] = ka[1];
                this.ke[9] = ka[2];
                this.ke[10] = ka[3];
                this.ke[11] = ka[0];
                CamelliaKey.roldqo32(49, ka, 0, this.subkey, 40);
                this.subkey[0] = kb[0];
                this.subkey[1] = kb[1];
                this.subkey[2] = kb[2];
                this.subkey[3] = kb[3];
                CamelliaKey.roldq(30, kb, 0, this.subkey, 12);
                CamelliaKey.roldq(30, kb, 0, this.subkey, 28);
                CamelliaKey.roldqo32(51, kb, 0, this.kw, 4);
            } else {
                this.kw[4] = k[0];
                this.kw[5] = k[1];
                this.kw[6] = k[2];
                this.kw[7] = k[3];
                CamelliaKey.decroldqo32(45, k, 0, this.subkey, 28);
                CamelliaKey.decroldq(15, k, 0, this.ke, 4);
                CamelliaKey.decroldq(17, k, 0, this.subkey, 12);
                CamelliaKey.decroldqo32(34, k, 0, this.subkey, 0);
                CamelliaKey.decroldq(15, k, 4, this.subkey, 40);
                CamelliaKey.decroldq(15, k, 4, this.ke, 8);
                CamelliaKey.decroldq(30, k, 4, this.subkey, 20);
                CamelliaKey.decroldqo32(34, k, 4, this.subkey, 8);
                CamelliaKey.decroldq(15, ka, 0, this.subkey, 36);
                CamelliaKey.decroldq(30, ka, 0, this.subkey, 24);
                this.ke[2] = ka[1];
                this.ke[3] = ka[2];
                this.ke[0] = ka[3];
                this.ke[1] = ka[0];
                CamelliaKey.decroldqo32(49, ka, 0, this.subkey, 4);
                this.subkey[46] = kb[0];
                this.subkey[47] = kb[1];
                this.subkey[44] = kb[2];
                this.subkey[45] = kb[3];
                CamelliaKey.decroldq(30, kb, 0, this.subkey, 32);
                CamelliaKey.decroldq(30, kb, 0, this.subkey, 16);
                CamelliaKey.roldqo32(51, kb, 0, this.kw, 0);
            }
        }
    }
}

