/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage.blob;

import io.trino.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.blob.BlobEncryptionPolicy;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.blob.BlobOutputStream;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.blob.LengthLimitingStream;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

class BlobDecryptStream
extends BlobOutputStream {
    private final OutputStream userStream;
    private final Map<String, String> metadata;
    private long position;
    private Long userProvidedLength;
    private byte[] iv = new byte[16];
    private BlobEncryptionPolicy encryptionPolicy;
    private int discardFirst;
    private OutputStream cryptoStream;
    private boolean bufferIV;
    private boolean noPadding;
    private Boolean requireEncryption;

    public BlobDecryptStream(OutputStream userStream, Map<String, String> metadata, Long userProvidedLength, int discardFirst, boolean bufferIV, boolean noPadding, BlobEncryptionPolicy policy, Boolean requireEncryption) {
        this.userStream = userStream;
        this.metadata = metadata;
        this.userProvidedLength = userProvidedLength;
        this.discardFirst = discardFirst;
        this.encryptionPolicy = policy;
        this.bufferIV = bufferIV;
        this.noPadding = noPadding;
        this.requireEncryption = requireEncryption;
    }

    @Override
    public void close() throws IOException {
        this.cryptoStream.close();
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.bufferIV && this.position < 16L) {
            int bytesToCopy = 16 - (int)this.position;
            bytesToCopy = length > bytesToCopy ? bytesToCopy : length;
            System.arraycopy(data, offset, this.iv, (int)this.position, bytesToCopy);
            this.position += (long)bytesToCopy;
            offset += bytesToCopy;
            length -= bytesToCopy;
        }
        if (this.cryptoStream == null) {
            LengthLimitingStream lengthLimitingStream = new LengthLimitingStream(this.userStream, this.discardFirst, this.userProvidedLength);
            try {
                this.cryptoStream = this.encryptionPolicy.decryptBlob(lengthLimitingStream, this.metadata, this.requireEncryption, !this.bufferIV ? null : this.iv, this.noPadding);
            }
            catch (StorageException e) {
                throw Utility.initIOException(e);
            }
        }
        if (length > 0) {
            this.cryptoStream.write(data, offset, length);
            this.position += (long)length;
        }
    }

    @Override
    public void write(InputStream sourceStream, long writeLength) throws IOException, StorageException {
        Utility.writeToOutputStream(sourceStream, this, writeLength, false, false, null, null);
    }

    @Override
    public void flush() throws IOException {
        this.userStream.flush();
    }
}

