/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.cache.AbstractLoadingCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

class EvictableCache<K, V>
extends AbstractLoadingCache<K, V>
implements LoadingCache<K, V> {
    private final ConcurrentHashMap<K, Token<K>> tokens = new ConcurrentHashMap();
    private final LoadingCache<Token<K>, V> dataCache;

    EvictableCache(CacheBuilder<? super Token<K>, ? super V> cacheBuilder, CacheLoader<? super K, V> cacheLoader) {
        this.dataCache = EvictableCache.buildUnsafeCache(cacheBuilder.removalListener(removal -> {
            Token token = (Token)removal.getKey();
            Verify.verify((token != null ? 1 : 0) != 0, (String)"token is null", (Object[])new Object[0]);
            Token token2 = token;
            synchronized (token2) {
                if (removal.getCause() == RemovalCause.REPLACED) {
                    return;
                }
                if (removal.getCause() == RemovalCause.EXPIRED && token.hasOngoingLoad()) {
                    return;
                }
                this.tokens.remove(token.getKey(), token);
            }
        }), new TokenCacheLoader<K, V>(cacheLoader));
    }

    @SuppressModernizer
    private static <K, V> LoadingCache<K, V> buildUnsafeCache(CacheBuilder<? super K, ? super V> cacheBuilder, CacheLoader<? super K, V> cacheLoader) {
        return cacheBuilder.build(cacheLoader);
    }

    public V getIfPresent(Object key) {
        Token<K> token = this.tokens.get(key);
        if (token == null) {
            return null;
        }
        return (V)this.dataCache.getIfPresent(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        Token newToken = new Token(key);
        Token token = this.tokens.computeIfAbsent(key, ignored -> newToken);
        try {
            Object object;
            token.startLoading();
            try {
                object = this.dataCache.get((Object)token, valueLoader);
                token.endLoading();
            }
            catch (Throwable throwable) {
                try {
                    token.endLoading();
                    throw throwable;
                }
                catch (Throwable e) {
                    if (newToken == token) {
                        this.tokens.remove(key, newToken);
                    }
                    throw e;
                }
            }
            return (V)object;
        }
        finally {
            this.removeDangling(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) throws ExecutionException {
        Token newToken = new Token(key);
        Token token = this.tokens.computeIfAbsent(key, ignored -> newToken);
        try {
            Object object;
            token.startLoading();
            try {
                object = this.dataCache.get((Object)token);
                token.endLoading();
            }
            catch (Throwable throwable) {
                try {
                    token.endLoading();
                    throw throwable;
                }
                catch (Throwable e) {
                    if (newToken == token) {
                        this.tokens.remove(key, newToken);
                    }
                    throw e;
                }
            }
            return (V)object;
        }
        finally {
            this.removeDangling(token);
        }
    }

    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        ArrayList<Token<K>> newTokens = new ArrayList<Token<K>>();
        ArrayList<Token<K>> temporaryTokens = new ArrayList<Token<K>>();
        try {
            LinkedHashMap result = new LinkedHashMap();
            for (K k : keys) {
                if (result.containsKey(k)) continue;
                Token<K> token = new Token<K>(k);
                Token<K> oldToken = this.tokens.putIfAbsent(k, token);
                if (oldToken != null) {
                    Object value = this.dataCache.getIfPresent(oldToken);
                    if (value != null) {
                        result.put(k, value);
                        continue;
                    }
                    temporaryTokens.add(token);
                }
                newTokens.add(token);
            }
            ImmutableMap values = this.dataCache.getAll(newTokens);
            for (Map.Entry entry : values.entrySet()) {
                Token newToken = (Token)entry.getKey();
                result.put(newToken.getKey(), entry.getValue());
            }
            ImmutableMap immutableMap = ImmutableMap.copyOf(result);
            return immutableMap;
        }
        catch (Throwable e) {
            for (Token token : newTokens) {
                this.tokens.remove(token.getKey(), token);
            }
            throw e;
        }
        finally {
            this.dataCache.invalidateAll(temporaryTokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDangling(Token<K> token) {
        Token<K> token2 = token;
        synchronized (token2) {
            if (!this.dataCache.asMap().containsKey(token) && !token.hasOngoingLoad()) {
                this.tokens.remove(token.getKey(), token);
            }
        }
    }

    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }

    public long size() {
        return this.dataCache.size();
    }

    public void cleanUp() {
        this.dataCache.cleanUp();
    }

    @VisibleForTesting
    int tokensCount() {
        return this.tokens.size();
    }

    public void invalidate(Object key) {
        Token<K> token = this.tokens.remove(key);
        if (token != null) {
            this.dataCache.invalidate(token);
        }
    }

    public void invalidateAll() {
        this.dataCache.invalidateAll();
        this.tokens.clear();
    }

    @VisibleForTesting
    void clearDataCacheOnly() {
        HashMap<K, Token<K>> tokensCopy = new HashMap<K, Token<K>>(this.tokens);
        this.dataCache.asMap().clear();
        Verify.verify((boolean)this.tokens.isEmpty(), (String)"Clearing dataCache should trigger tokens eviction", (Object[])new Object[0]);
        this.tokens.putAll(tokensCopy);
    }

    public CacheStats stats() {
        return this.dataCache.stats();
    }

    public ConcurrentMap<K, V> asMap() {
        return new ConcurrentMap<K, V>(){
            private final ConcurrentMap<Token<K>, V> dataCacheMap;
            {
                this.dataCacheMap = EvictableCache.this.dataCache.asMap();
            }

            @Override
            public V putIfAbsent(K key, V value) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation");
            }

            @Override
            public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation");
            }

            @Override
            public boolean remove(Object key, Object value) {
                Token token = EvictableCache.this.tokens.get(key);
                if (token != null) {
                    return this.dataCacheMap.remove(token, value);
                }
                return false;
            }

            @Override
            public boolean replace(K key, V oldValue, V newValue) {
                Token token = EvictableCache.this.tokens.get(key);
                if (token != null) {
                    return this.dataCacheMap.replace(token, oldValue, newValue);
                }
                return false;
            }

            @Override
            public V replace(K key, V value) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation");
            }

            @Override
            public int size() {
                return EvictableCache.this.dataCache.asMap().size();
            }

            @Override
            public boolean isEmpty() {
                return EvictableCache.this.dataCache.asMap().isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return EvictableCache.this.tokens.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return this.values().contains(value);
            }

            @Override
            @Nullable
            public V get(Object key) {
                return EvictableCache.this.getIfPresent(key);
            }

            @Override
            public V put(K key, V value) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation. Use get(key, callable) instead.");
            }

            @Override
            @Nullable
            public V remove(Object key) {
                Token token = EvictableCache.this.tokens.remove(key);
                if (token != null) {
                    return this.dataCacheMap.remove(token);
                }
                return null;
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> m) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation. Use get(key, callable) instead.");
            }

            @Override
            public void clear() {
                this.dataCacheMap.clear();
                EvictableCache.this.tokens.clear();
            }

            @Override
            public Set<K> keySet() {
                return EvictableCache.this.tokens.keySet();
            }

            @Override
            public Collection<V> values() {
                return this.dataCacheMap.values();
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class TokenCacheLoader<K, V>
    extends CacheLoader<Token<K>, V> {
        private final CacheLoader<? super K, V> delegate;

        public TokenCacheLoader(CacheLoader<? super K, V> delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public V load(Token<K> token) throws Exception {
            return (V)this.delegate.load(token.getKey());
        }

        public ListenableFuture<V> reload(Token<K> token, V oldValue) throws Exception {
            return this.delegate.reload(token.getKey(), oldValue);
        }

        public Map<Token<K>, V> loadAll(Iterable<? extends Token<K>> tokens) throws Exception {
            Map values;
            ImmutableList tokenList = ImmutableList.copyOf(tokens);
            ArrayList keys = new ArrayList();
            for (Token token : tokenList) {
                keys.add(token.getKey());
            }
            try {
                values = this.delegate.loadAll(keys);
            }
            catch (CacheLoader.UnsupportedLoadingOperationException e) {
                throw new UnsupportedOperationException("LoadingCache.getAll() is not supported by EvictableCache when CacheLoader.loadAll is not implemented", e);
            }
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (int i = 0; i < tokenList.size(); ++i) {
                Token token = (Token)tokenList.get(i);
                Object key = keys.get(i);
                Object value = values.get(key);
                if (value == null) continue;
                result.put((Object)token, value);
            }
            return result.buildOrThrow();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).addValue(this.delegate).toString();
        }
    }

    static final class Token<K> {
        private final K key;
        @GuardedBy(value="this")
        private int ongoingLoads;

        Token(K key) {
            this.key = Objects.requireNonNull(key, "key is null");
        }

        K getKey() {
            return this.key;
        }

        public String toString() {
            return String.format("CacheToken(%s; %s)", Integer.toHexString(this.hashCode()), this.key);
        }

        synchronized boolean hasOngoingLoad() {
            return this.ongoingLoads > 0;
        }

        synchronized void startLoading() {
            ++this.ongoingLoads;
        }

        synchronized void endLoading() {
            --this.ongoingLoads;
            Verify.verify((this.ongoingLoads >= 0 ? 1 : 0) != 0, (String)"ongoingLoads must be greater than or equal 0", (Object[])new Object[0]);
        }
    }
}

