/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.openjdk.jol.info.GraphPathRecord;
import org.openjdk.jol.info.GraphVisitor;
import org.openjdk.jol.info.GraphWalker;
import org.openjdk.jol.util.Multiset;
import org.openjdk.jol.util.ObjectUtils;
import org.openjdk.jol.vm.VM;

public class GraphLayout {
    private final List<GraphPathRecord> gprs = new ArrayList<GraphPathRecord>();
    private final String description;
    private volatile boolean processedHisto;
    private Set<Class<?>> classes;
    private Multiset<Class<?>> classSizes;
    private Multiset<Class<?>> classCounts;
    private volatile boolean processedAddresses;
    private Map<Long, GraphPathRecord> addresses;
    private long minAddress;
    private long maxAddress;
    private int addressTries;
    private boolean addressStable;
    private volatile boolean processedTotals;
    private long totalCount;
    private long totalSize;

    public static GraphLayout parseInstance(Object ... roots) {
        return new GraphWalker(new GraphVisitor[0]).walk(roots);
    }

    public GraphLayout(Object ... roots) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object root : roots) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(String.format("%s@%xd", root.getClass().getName(), System.identityHashCode(root)));
        }
        this.description = sb.toString();
    }

    void addRecord(GraphPathRecord gpr) {
        this.gprs.add(gpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureProcessedAddresses() {
        if (this.processedAddresses) {
            return;
        }
        GraphLayout graphLayout = this;
        synchronized (graphLayout) {
            if (this.gprs.isEmpty()) {
                this.minAddress = 0L;
                this.maxAddress = 0L;
            }
            this.addresses = new HashMap<Long, GraphPathRecord>();
            long[] rawAddresses = new long[this.gprs.size()];
            for (int i = 0; i < this.gprs.size(); ++i) {
                rawAddresses[i] = VM.current().addressOf(this.gprs.get(i).obj());
            }
            boolean good = false;
            this.addressTries = 0;
            while (this.addressTries < 10 && !good) {
                this.addresses.clear();
                this.minAddress = Long.MAX_VALUE;
                this.maxAddress = Long.MIN_VALUE;
                good = true;
                for (int i = 0; i < this.gprs.size(); ++i) {
                    GraphPathRecord gpr = this.gprs.get(i);
                    Object o = gpr.obj();
                    long addr = VM.current().addressOf(o);
                    if (rawAddresses[i] != addr) {
                        rawAddresses[i] = addr;
                        good = false;
                    }
                    if (!good) continue;
                    this.addresses.put(addr, gpr);
                    this.minAddress = Math.min(this.minAddress, addr);
                    this.maxAddress = Math.max(this.maxAddress, addr);
                }
                ++this.addressTries;
            }
            this.addressStable = good;
            this.processedAddresses = true;
        }
    }

    public GraphLayout subtract(GraphLayout another) {
        this.ensureProcessedAddresses();
        another.ensureProcessedAddresses();
        GraphLayout res = new GraphLayout(new Object[0]);
        for (Map.Entry<Long, GraphPathRecord> e : this.addresses.entrySet()) {
            if (another.addresses.containsKey(e.getKey())) continue;
            res.addRecord(e.getValue());
        }
        return res;
    }

    public GraphLayout add(GraphLayout another) {
        this.ensureProcessedAddresses();
        another.ensureProcessedAddresses();
        GraphLayout res = new GraphLayout(new Object[0]);
        for (Map.Entry<Long, GraphPathRecord> e : this.addresses.entrySet()) {
            res.addRecord(e.getValue());
        }
        for (Map.Entry<Long, GraphPathRecord> e : another.addresses.entrySet()) {
            if (this.addresses.containsKey(e.getKey())) continue;
            res.addRecord(e.getValue());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureProcessedHisto() {
        if (this.processedHisto) {
            return;
        }
        GraphLayout graphLayout = this;
        synchronized (graphLayout) {
            this.classes = new TreeSet<Class>(Comparator.comparing(Class::getName));
            this.classSizes = new Multiset();
            this.classCounts = new Multiset();
            for (GraphPathRecord gpr : this.gprs) {
                Class<?> klass = gpr.klass();
                this.classes.add(klass);
                this.classCounts.add(klass);
                try {
                    this.classSizes.add(klass, gpr.size());
                }
                catch (Exception e) {
                    this.classSizes.add(klass, 0L);
                }
            }
            this.processedHisto = true;
        }
    }

    public Multiset<Class<?>> getClassSizes() {
        this.ensureProcessedHisto();
        return this.classSizes;
    }

    public Multiset<Class<?>> getClassCounts() {
        this.ensureProcessedHisto();
        return this.classCounts;
    }

    public Set<Class<?>> getClasses() {
        this.ensureProcessedHisto();
        return this.classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureProcessedTotals() {
        if (this.processedTotals) {
            return;
        }
        GraphLayout graphLayout = this;
        synchronized (graphLayout) {
            for (GraphPathRecord gpr : this.gprs) {
                this.totalSize += gpr.size();
            }
            this.totalCount = this.gprs.size();
            this.processedTotals = true;
        }
    }

    public long totalCount() {
        this.ensureProcessedTotals();
        return this.totalCount;
    }

    public long totalSize() {
        this.ensureProcessedTotals();
        return this.totalSize;
    }

    public long startAddress() {
        this.ensureProcessedAddresses();
        return this.minAddress;
    }

    public long endAddress() {
        this.ensureProcessedAddresses();
        return this.maxAddress;
    }

    public SortedSet<Long> addresses() {
        this.ensureProcessedAddresses();
        return new TreeSet<Long>(this.addresses.keySet());
    }

    public GraphPathRecord record(long address) {
        this.ensureProcessedAddresses();
        return this.addresses.get(address);
    }

    public String toFootprint() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(this.description + " footprint:");
        pw.printf(" %9s %9s %9s   %s%n", "COUNT", "AVG", "SUM", "DESCRIPTION");
        for (Class<?> key : this.getClasses()) {
            long count = this.getClassCounts().count(key);
            long size = this.getClassSizes().count(key);
            pw.printf(" %9d %9d %9d   %s%n", count, size / count, size, key.getName());
        }
        pw.printf(" %9d %9s %9d   %s%n", this.totalCount(), "", this.totalSize(), "(total)");
        pw.println();
        pw.close();
        return sw.toString();
    }

    public String toPrintable() {
        long addr;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        long last = 0L;
        int typeLen = "TYPE".length();
        Iterator iterator = this.addresses().iterator();
        while (iterator.hasNext()) {
            addr = (Long)iterator.next();
            GraphPathRecord r = this.record(addr);
            typeLen = Math.max(typeLen, r.klass().getName().length());
        }
        pw.println(this.description + " object externals:");
        pw.printf(" %16s %10s %-" + typeLen + "s %-30s %s%n", "ADDRESS", "SIZE", "TYPE", "PATH", "VALUE");
        iterator = this.addresses().iterator();
        while (iterator.hasNext()) {
            addr = (Long)iterator.next();
            GraphPathRecord record = this.record(addr);
            long size = record.size();
            if (addr > last && last != 0L) {
                pw.printf(" %16x %10d %-" + typeLen + "s %-30s %s%n", last, addr - last, "(something else)", "(somewhere else)", "(something else)");
            }
            if (addr < last) {
                pw.printf(" %16x %10d %-" + typeLen + "s %-30s %s%n", last, addr - last, "**** OVERLAP ****", "**** OVERLAP ****", "**** OVERLAP ****");
            }
            pw.printf(" %16x %10d %-" + typeLen + "s %-30s %s%n", addr, size, record.klass().getName(), record.path(), ObjectUtils.safeToString(record.obj()));
            last = addr + size;
        }
        pw.println();
        pw.println("Addresses are " + (this.addressStable ? "stable" : "still unstable") + " after " + this.addressTries + " tries.");
        pw.println();
        pw.close();
        return sw.toString();
    }

    public void toImage(String fileName) throws IOException {
        int depth;
        long end;
        if (this.addresses().isEmpty()) {
            return;
        }
        long start = this.startAddress();
        if (start == (end = this.endAddress() + this.record(this.endAddress()).size())) {
            end = start + 1L;
        }
        int WIDTH = 1000;
        int HEIGHT = 320;
        int GRAPH_HEIGHT = 100;
        int SCALE_WIDTH = 30;
        int EXT_PAD = 50;
        int PAD = 20;
        BufferedImage image = new BufferedImage(1000, 320, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 1000, 320);
        int minDepth = Integer.MAX_VALUE;
        int maxDepth = Integer.MIN_VALUE;
        Iterator iterator = this.addresses().iterator();
        while (iterator.hasNext()) {
            long addr = (Long)iterator.next();
            GraphPathRecord p = this.record(addr);
            minDepth = Math.min(minDepth, p.depth());
            maxDepth = Math.max(maxDepth, p.depth());
        }
        Multiset<Integer> depths = new Multiset<Integer>();
        Iterator addr = this.addresses().iterator();
        while (addr.hasNext()) {
            long addr2 = (Long)addr.next();
            GraphPathRecord r = this.record(addr2);
            depths.add(r.depth(), r.size());
        }
        int lastX = 0;
        Iterator addr2 = this.addresses().iterator();
        while (addr2.hasNext()) {
            long addr3 = (Long)addr2.next();
            long size = this.record(addr3).size();
            int x1 = 80 + (int)(870L * (addr3 - start) / (end - start));
            int x2 = 80 + (int)(870L * (addr3 + size - start) / (end - start));
            x1 = Math.max(x1, lastX);
            x2 = Math.max(x2, lastX);
            float relDepth = 1.0f * (float)(this.record(addr3).depth() - minDepth) / (float)(maxDepth - minDepth + 1);
            g.setColor(Color.getHSBColor(relDepth, 1.0f, 0.9f));
            g.fillRect(x1, 50, x2 - x1, 100);
        }
        for (depth = minDepth; depth <= maxDepth; ++depth) {
            float relDepth = 1.0f * (float)(depth - minDepth) / (float)(maxDepth - minDepth + 1);
            g.setColor(Color.getHSBColor(relDepth, 1.0f, 0.9f));
            int y1 = 320 * (depth - minDepth) / (maxDepth - minDepth + 1);
            int y2 = 320 * (depth + 1 - minDepth) / (maxDepth - minDepth + 1);
            g.fillRect(0, y1, 30, y2 - y1);
        }
        lastX = 80;
        for (depth = minDepth; depth <= maxDepth; ++depth) {
            int w = (int)(870L * depths.count(depth) / (end - start));
            float relDepth = 1.0f * (float)(depth - minDepth) / (float)(maxDepth - minDepth + 1);
            g.setColor(Color.getHSBColor(relDepth, 1.0f, 0.9f));
            g.fillRect(lastX, 170, w, 100);
            lastX += w;
        }
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(2.0f));
        g.drawRect(80, 50, 870, 100);
        g.drawRect(80, 170, 870, 100);
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(80, 290, 950, 290);
        g.drawLine(80, 285, 80, 295);
        g.drawLine(950, 285, 950, 295);
        Font font = new Font("Serif", 0, 18);
        g.setFont(font);
        String labelDense = (end - start) / 1024L + " Kb";
        g.setBackground(Color.WHITE);
        g.setColor(Color.BLACK);
        g.drawString(labelDense, 450, 310);
        g.drawString(String.format("%s", this.description), 80, 30);
        AffineTransform orig = g.getTransform();
        int x = 75;
        int y1 = 150;
        g.rotate(-Math.toRadians(90.0), x, y1);
        g.drawString("Actual:", x, y1);
        g.setTransform(orig);
        int y2 = 270;
        g.rotate(-Math.toRadians(90.0), x, y2);
        g.drawString("Dense:", x, y2);
        g.setTransform(orig);
        ImageIO.write((RenderedImage)image, "png", new File(fileName));
    }
}

