/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.ByteArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.util.Optional;

public final class BooleanType
extends AbstractType
implements FixedWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(BooleanType.class, MethodHandles.lookup(), Boolean.TYPE);
    private static final long TRUE_XX_HASH = XxHash64.hash((long)1L);
    private static final long FALSE_XX_HASH = XxHash64.hash((long)0L);
    public static final BooleanType BOOLEAN = new BooleanType();

    public static Block wrapByteArrayAsBooleanBlockWithoutNulls(byte[] booleansAsBytes) {
        return new ByteArrayBlock(booleansAsBytes.length, Optional.empty(), booleansAsBytes);
    }

    public static Block createBlockForSingleNonNullValue(boolean value) {
        byte byteValue = value ? (byte)1 : 0;
        return new ByteArrayBlock(1, Optional.empty(), new byte[]{byteValue});
    }

    private BooleanType() {
        super(new TypeSignature("boolean", new TypeSignatureParameter[0]), Boolean.TYPE, ByteArrayBlock.class);
    }

    @Override
    public int getFixedSize() {
        return 1;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new ByteArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 1));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 1);
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new ByteArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return this.getBoolean(block, position);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            ((ByteArrayBlockBuilder)blockBuilder).writeByte(this.getBoolean(block, position) ? (byte)1 : 0);
        }
    }

    @Override
    public boolean getBoolean(Block block, int position) {
        return BooleanType.read((ByteArrayBlock)block.getUnderlyingValueBlock(), block.getUnderlyingValuePosition(position));
    }

    @Override
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        ((ByteArrayBlockBuilder)blockBuilder).writeByte((byte)(value ? 1 : 0));
    }

    @Override
    public int getFlatFixedSize() {
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        return other == BOOLEAN;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static boolean read(@BlockPosition ByteArrayBlock block, @BlockIndex int position) {
        return block.getByte(position) != 0;
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static boolean readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice) {
        return fixedSizeSlice[fixedSizeOffset] != 0;
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(boolean value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        fixedSizeSlice[fixedSizeOffset] = (byte)(value ? 1 : 0);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(boolean left, boolean right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(boolean value) {
        return value ? TRUE_XX_HASH : FALSE_XX_HASH;
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(boolean left, boolean right) {
        return Boolean.compare(left, right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(boolean left, boolean right) {
        return !left && right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(boolean left, boolean right) {
        return !left || right;
    }
}

