/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.security;

import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.PrivilegeInfo;
import io.trino.spi.security.TrinoPrincipal;
import java.util.Objects;
import java.util.Optional;

public class GrantInfo {
    private final PrivilegeInfo privilegeInfo;
    private final TrinoPrincipal grantee;
    private final SchemaTableName schemaTableName;
    private final Optional<TrinoPrincipal> grantor;
    private final Optional<Boolean> withHierarchy;

    public GrantInfo(PrivilegeInfo privilegeInfo, TrinoPrincipal grantee, SchemaTableName schemaTableName, Optional<TrinoPrincipal> grantor, Optional<Boolean> withHierarchy) {
        this.privilegeInfo = Objects.requireNonNull(privilegeInfo, "privilegeInfo is null");
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.grantor = Objects.requireNonNull(grantor, "grantor is null");
        this.withHierarchy = Objects.requireNonNull(withHierarchy, "withHierarchy is null");
    }

    public PrivilegeInfo getPrivilegeInfo() {
        return this.privilegeInfo;
    }

    public TrinoPrincipal getGrantee() {
        return this.grantee;
    }

    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    public Optional<TrinoPrincipal> getGrantor() {
        return this.grantor;
    }

    public Optional<Boolean> getWithHierarchy() {
        return this.withHierarchy;
    }

    public int hashCode() {
        return Objects.hash(this.privilegeInfo, this.grantee, this.schemaTableName, this.grantor, this.withHierarchy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantInfo grantInfo = (GrantInfo)o;
        return Objects.equals(this.privilegeInfo, grantInfo.getPrivilegeInfo()) && Objects.equals(this.grantee, grantInfo.getGrantee()) && Objects.equals(this.schemaTableName, grantInfo.getSchemaTableName()) && Objects.equals(this.grantor, grantInfo.getGrantor()) && Objects.equals(this.withHierarchy, grantInfo.getWithHierarchy());
    }
}

