/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.tracing;

import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.json.JsonBinder;
import io.airlift.node.NodeInfo;
import io.airlift.tracing.SpanSerialization;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.ServiceAttributes;
import io.opentelemetry.semconv.incubating.DeploymentIncubatingAttributes;
import io.opentelemetry.semconv.incubating.HostIncubatingAttributes;
import io.opentelemetry.semconv.incubating.OsIncubatingAttributes;
import io.opentelemetry.semconv.incubating.ProcessIncubatingAttributes;
import io.opentelemetry.semconv.incubating.ServiceIncubatingAttributes;
import java.util.Objects;
import java.util.Set;
import ru.cedrusdata.catalog.config.CatalogConfig;
import ru.cedrusdata.catalog.tracing.TracingProvider;
import ru.cedrusdata.catalog.tracing.TracingSpanProcessorModule;

public class CatalogTracingModule
extends AbstractConfigurationAwareModule {
    private static final String SERVICE_NAME = "cedrusdata-catalog";
    private static final String NODE_ANNOTATION_PREFIX = "ru.cedrusdata.catalog";
    private final String serviceVersion;

    public CatalogTracingModule(String serviceVersion) {
        this.serviceVersion = Objects.requireNonNull(serviceVersion, "serviceVersion is null");
    }

    protected void setup(Binder binder) {
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Span.class).to(SpanSerialization.SpanSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Span.class).to(SpanSerialization.SpanDeserializer.class);
        Multibinder.newSetBinder((Binder)binder, SpanProcessor.class);
        if (((CatalogConfig)this.buildConfigObject(CatalogConfig.class)).getTelemetryEnabled().enabled()) {
            binder.install((Module)new TracingSpanProcessorModule());
        }
        binder.bind(TracingProvider.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public OpenTelemetry createOpenTelemetry(NodeInfo nodeInfo, Set<SpanProcessor> spanProcessors, CatalogConfig config) {
        if (!config.getTelemetryEnabled().enabled()) {
            return OpenTelemetry.noop();
        }
        String processRuntime = CatalogTracingModule.processRuntime();
        String osType = CatalogTracingModule.osType();
        String osName = StandardSystemProperty.OS_NAME.value();
        String osVersion = StandardSystemProperty.OS_VERSION.value();
        String hostArch = CatalogTracingModule.hostArch();
        AttributesBuilder attributes = Attributes.builder().put(ServiceAttributes.SERVICE_NAME, (Object)SERVICE_NAME).put(ServiceAttributes.SERVICE_VERSION, (Object)this.serviceVersion).put(ServiceIncubatingAttributes.SERVICE_INSTANCE_ID, (Object)nodeInfo.getNodeId()).put(DeploymentIncubatingAttributes.DEPLOYMENT_ENVIRONMENT_NAME, (Object)nodeInfo.getEnvironment()).put(ProcessIncubatingAttributes.PROCESS_RUNTIME_NAME, (Object)System.getProperty("java.runtime.name")).put(ProcessIncubatingAttributes.PROCESS_RUNTIME_VERSION, (Object)System.getProperty("java.runtime.version"));
        if (processRuntime != null) {
            attributes.put(ProcessIncubatingAttributes.PROCESS_RUNTIME_DESCRIPTION, (Object)processRuntime);
        }
        if (osType != null) {
            attributes.put(OsIncubatingAttributes.OS_TYPE, (Object)osType);
        }
        if (osName != null) {
            attributes.put(OsIncubatingAttributes.OS_NAME, (Object)osName);
        }
        if (osVersion != null) {
            attributes.put(OsIncubatingAttributes.OS_VERSION, (Object)osVersion);
        }
        if (hostArch != null) {
            attributes.put(HostIncubatingAttributes.HOST_ARCH, (Object)hostArch);
        }
        nodeInfo.getAnnotations().forEach((key, value) -> attributes.put(String.format("%s.%s", NODE_ANNOTATION_PREFIX, key), value));
        Resource resource = Resource.getDefault().merge(Resource.create((Attributes)attributes.build()));
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().setSampler(Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)config.getTelemetrySamplingRatio()))).addSpanProcessor(SpanProcessor.composite(spanProcessors)).setResource(resource).build();
        return OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).build();
    }

    @Provides
    @Singleton
    public Tracer createTracer(OpenTelemetry openTelemetry) {
        return openTelemetry.getTracer(SERVICE_NAME);
    }

    private static String processRuntime() {
        String vendor = StandardSystemProperty.JAVA_VM_VENDOR.value();
        String name = StandardSystemProperty.JAVA_VM_NAME.value();
        String version = StandardSystemProperty.JAVA_VM_VERSION.value();
        if (vendor == null && name == null && version == null) {
            return null;
        }
        return "%s %s %s".formatted(vendor, name, version);
    }

    private static String osType() {
        return switch (Strings.nullToEmpty((String)StandardSystemProperty.OS_NAME.value())) {
            case "Linux" -> "linux";
            case "Mac OS X" -> "darwin";
            default -> null;
        };
    }

    private static String hostArch() {
        return switch (Strings.nullToEmpty((String)StandardSystemProperty.OS_ARCH.value())) {
            case "amd64", "x86_64" -> "amd64";
            case "aarch64" -> "arm64";
            case "ppc64le" -> "ppc64";
            default -> null;
        };
    }
}

