/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc.sqlite;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.sqlite.SQLiteErrorCode;
import org.sqlite.SQLiteException;
import ru.cedrusdata.catalog.store.jdbc.SqlDialect;

public class SqliteSqlDialect
implements SqlDialect {
    private static final Set<Integer> CONSTRAINT_VIOLATION_ERROR_CODES = Arrays.stream(SQLiteErrorCode.values()).filter(value -> value.name().startsWith("SQLITE_CONSTRAINT")).map(value -> value.code).collect(Collectors.toSet());

    @Override
    public boolean isConstraintViolationException(Throwable throwable) {
        if (throwable instanceof SQLiteException) {
            SQLiteException sqliteException = (SQLiteException)throwable;
            return CONSTRAINT_VIOLATION_ERROR_CODES.contains(sqliteException.getResultCode().code);
        }
        return false;
    }

    @Override
    public UUID getUuid(ResultSet rs, String columnLabel) throws SQLException {
        String value = rs.getString(columnLabel);
        return value != null ? UUID.fromString(value) : null;
    }

    @Override
    public String forUpdate(String sql) {
        return sql.replace("{for-update}", "").trim();
    }
}

