/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import io.airlift.json.JsonCodec;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.PreparedBatch;

public final class JdbcUtils {
    private static final JsonCodec<Map<String, String>> PROPERTIES_CODEC = JsonCodec.mapJsonCodec(String.class, String.class);

    private JdbcUtils() {
    }

    public static String propertiesToString(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        return PROPERTIES_CODEC.toJson(properties);
    }

    public static Map<String, String> stringToProperties(String value) {
        if (value == null) {
            return Map.of();
        }
        return (Map)PROPERTIES_CODEC.fromJson(value);
    }

    public static Map<String, String> stringToPropertiesOrNull(String value) {
        if (value == null) {
            return null;
        }
        return (Map)PROPERTIES_CODEC.fromJson(value);
    }

    public static <T> void executeBatch(Handle handle, String sql, Collection<T> items, BiConsumer<PreparedBatch, T> itemsOp) {
        if (items == null || items.isEmpty()) {
            return;
        }
        PreparedBatch batch = handle.prepareBatch(sql);
        for (T object : items) {
            itemsOp.accept(batch, (PreparedBatch)object);
        }
        batch.execute();
    }
}

