/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.common.base.Verify;
import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilege;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeDetails;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeTypeDetails;
import ru.cedrusdata.catalog.core.security.authorization.securable.CatalogInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ComputeEngineInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.FileSystemInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.JobInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.MetastoreInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.NamespaceInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectGroupInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.PrincipalInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableItem;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurityProviderInternalSecurable;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.spi.model.PrivilegeGrantInfo;
import ru.cedrusdata.catalog.spi.model.Securable;
import ru.cedrusdata.catalog.store.PrivilegeStore;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;

@StoreTracingInterceptor.Traceable
public class JdbcPrivilegeStore
implements PrivilegeStore {
    @Language(value="SQL")
    private static final String SQL_CREATE = "INSERT INTO metastore_privilege (\n    principal_id,\n    privilege_type_id,\n    securable_id,\n    owner_id,\n    securable_principal_id,\n    securable_file_system_id,\n    securable_catalog_id,\n    securable_namespace_id,\n    securable_object_id,\n    securable_object_group_id,\n    securable_compute_engine_id,\n    securable_job_id,\n    securable_security_provider_id)\nVALUES (\n    :principal_id,\n    :privilege_type_id,\n    :securable_id,\n    :owner_id,\n    :securable_principal_id,\n    :securable_file_system_id,\n    :securable_catalog_id,\n    :securable_namespace_id,\n    :securable_object_id,\n    :securable_object_group_id,\n    :securable_compute_engine_id,\n    :securable_job_id,\n    :securable_security_provider_id)\nON CONFLICT DO NOTHING\n";
    @Language(value="SQL")
    public static final String SQL_DELETE = "DELETE FROM metastore_privilege\nWHERE principal_id = :principal_id AND privilege_type_id = :privilege_type_id AND securable_id = :securable_id\n";
    @Language(value="SQL")
    private static final String SQL_LIST = "SELECT\n    privilege.principal_id,\n    principal.principal_name,\n    privilege.securable_id,\n    privilege.privilege_type_id\nFROM metastore_privilege privilege\n    INNER JOIN metastore_principal principal ON privilege.principal_id = principal.principal_id\n";
    @Language(value="SQL")
    private static final String SQL_LIST_TYPES = "SELECT\n    privilege_type_id,\n    caption\nFROM metastore_privilege_type\n";
    @Language(value="SQL")
    private static final String SQL_RESOLVE_PRINCIPAL = "SELECT\n    principal_id,\n    owner_id\nFROM metastore_principal\nWHERE principal_name = :principal_name\n";
    @Language(value="SQL")
    private static final String SQL_RESOLVE_FILE_SYSTEM = "SELECT\n    file_system_id,\n    owner_id\nFROM metastore_file_system\nWHERE file_system_name = :file_system_name\n";
    @Language(value="SQL")
    private static final String SQL_RESOLVE_CATALOG = "SELECT\n    catalog_id,\n    owner_id catalog_owner_id\nFROM metastore_catalog\nWHERE catalog_name = :catalog_name\n";
    @Language(value="SQL")
    private static final String SQL_RESOLVE_NAMESPACE = "SELECT\n    c.catalog_id,\n    c.owner_id catalog_owner_id,\n    n.namespace_id,\n    n.owner_id namespace_owner_id\nFROM metastore_iceberg_namespace n\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\nWHERE c.catalog_name = :catalog_name AND n.namespace_name = :namespace_name\n";
    @Language(value="SQL")
    private static final String SQL_RESOLVE_OBJECT = "SELECT\n    c.catalog_id,\n    c.owner_id catalog_owner_id,\n    n.namespace_id,\n    n.owner_id namespace_owner_id,\n    t.table_id object_id,\n    t.owner_id object_owner_id\nFROM metastore_iceberg_table t\n    INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\nWHERE catalog_name = :catalog_name AND namespace_name = :namespace_name AND table_name = :table_name AND table_type = :table_type AND mv = :mv\n";
    @Language(value="SQL")
    private static final String SQL_RESOLVE_OBJECT_GROUP = "SELECT\n    group_id,\n    owner_id\nFROM metastore_object_group\nWHERE group_name = :group_name\n";
    @Language(value="SQL")
    private static final String SQL_RESOLVE_COMPUTE_ENGINE = "SELECT\n    engine_id,\n    owner_id\nFROM metastore_compute_engine\nWHERE engine_name = :engine_name\n";
    @Language(value="SQL")
    private static final String SQL_RESOLVE_JOB = "SELECT\n    e.engine_id,\n    e.engine_name,\n    e.owner_id engine_owner_id,\n    j.job_id,\n    j.owner_id job_owner_id\nFROM metastore_maintenance_job j\n    JOIN metastore_compute_engine e ON j.operation_engine_id = e.engine_id\nWHERE j.job_name = :job_name\n";
    @Language(value="SQL")
    private static final String SQL_RESOLVE_JOB_WITH_COMPUTE_ENGINE = "SELECT\n    e.engine_id,\n    e.owner_id engine_owner_id,\n    j.job_id,\n    j.owner_id job_owner_id\nFROM metastore_maintenance_job j\n    JOIN metastore_compute_engine e ON j.operation_engine_id = e.engine_id\nWHERE j.job_name = :job_name AND e.engine_name = :engine_name\n";
    @Language(value="SQL")
    private static final String SQL_RESOLVE_SECURITY_PROVIDER = "SELECT\n    provider_id,\n    owner_id\nFROM metastore_security_provider\nWHERE provider_name = :provider_name\n";
    @Language(value="SQL")
    private static final String SQL_LIST_GRANTS = "SELECT\n    p.principal_name grantee_name,\n    g.securable_id,\n    g.privilege_type_id,\n    s_p.principal_name securable_principal_name,\n    s_fs.file_system_name securable_file_system_name,\n    s_c.catalog_name securable_catalog_name,\n    s_n.namespace_name securable_namespace_name,\n    s_n_c.catalog_name securable_namespace_catalog_name,\n    s_o.table_name securable_object_name,\n    s_o_n.namespace_name securable_object_namespace_name,\n    s_o_c.catalog_name securable_object_catalog_name,\n    s_o.table_type securable_object_type,\n    s_o.mv securable_object_mv,\n    s_og.group_name securable_object_group_name,\n    s_ce.engine_name securable_compute_engine_name,\n    s_j.job_name securable_job_name,\n    s_j_ce.engine_name securable_job_compute_engine_name,\n    s_sp.provider_name securable_security_provider_name\nFROM metastore_privilege g\n    INNER JOIN metastore_principal p ON g.principal_id = p.principal_id\n    LEFT OUTER JOIN metastore_principal s_p ON g.securable_principal_id = s_p.principal_id\n    LEFT OUTER JOIN metastore_file_system s_fs ON g.securable_file_system_id = s_fs.file_system_id\n    LEFT OUTER JOIN metastore_catalog s_c ON g.securable_catalog_id = s_c.catalog_id\n    LEFT OUTER JOIN metastore_iceberg_namespace s_n ON g.securable_namespace_id = s_n.namespace_id\n    LEFT OUTER JOIN metastore_catalog s_n_c ON s_n.catalog_id = s_n_c.catalog_id\n    LEFT OUTER JOIN metastore_iceberg_table s_o ON g.securable_object_id = s_o.table_id\n    LEFT OUTER JOIN metastore_iceberg_namespace s_o_n ON s_o.namespace_id = s_o_n.namespace_id\n    LEFT OUTER JOIN metastore_catalog s_o_c ON s_o_n.catalog_id = s_o_c.catalog_id\n    LEFT OUTER JOIN metastore_object_group s_og ON g.securable_object_group_id = s_og.group_id\n    LEFT OUTER JOIN metastore_compute_engine s_ce ON g.securable_compute_engine_id = s_ce.engine_id\n    LEFT OUTER JOIN metastore_maintenance_job s_j ON g.securable_job_id = s_j.job_id\n    LEFT OUTER JOIN metastore_compute_engine s_j_ce ON s_j.operation_engine_id = s_j_ce.engine_id\n    LEFT OUTER JOIN metastore_security_provider s_sp ON g.securable_security_provider_id = s_sp.provider_id\nWHERE {condition}\n";
    private final JdbcAccessor accessor;

    @Inject
    public JdbcPrivilegeStore(JdbcAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public boolean createPrivileges(UUID principalId, Set<UUID> privilegeTypeIds, UUID securableId, UUID ownerId, Optional<UUID> securablePrincipalId, Optional<UUID> securableFileSystemId, Optional<UUID> securableCatalogId, Optional<UUID> securableNamespaceId, Optional<UUID> securableObjectId, Optional<UUID> securableObjectGroupId, Optional<UUID> securableComputeEngineId, Optional<UUID> securableJobId, Optional<UUID> securableSecurityProviderId) {
        return this.accessor.execute(handle -> {
            PreparedBatch batch = handle.prepareBatch(SQL_CREATE);
            for (UUID privilegeTypeId : privilegeTypeIds) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("principal_id", principalId)).bind("privilege_type_id", privilegeTypeId)).bind("securable_id", securableId)).bind("owner_id", ownerId)).bind("securable_principal_id", (UUID)securablePrincipalId.orElse(null))).bind("securable_file_system_id", (UUID)securableFileSystemId.orElse(null))).bind("securable_catalog_id", (UUID)securableCatalogId.orElse(null))).bind("securable_namespace_id", (UUID)securableNamespaceId.orElse(null))).bind("securable_object_id", (UUID)securableObjectId.orElse(null))).bind("securable_object_group_id", (UUID)securableObjectGroupId.orElse(null))).bind("securable_compute_engine_id", (UUID)securableComputeEngineId.orElse(null))).bind("securable_job_id", (UUID)securableJobId.orElse(null))).bind("securable_security_provider_id", (UUID)securableSecurityProviderId.orElse(null))).add();
            }
            int[] results = batch.execute();
            return Arrays.stream(results).anyMatch(value -> value > 0);
        });
    }

    @Override
    public boolean deletePrivileges(UUID principalId, Set<UUID> privilegeTypeIds, UUID securableId) {
        return this.accessor.execute(handle -> {
            PreparedBatch batch = handle.prepareBatch(SQL_DELETE);
            for (UUID privilegeTypeId : privilegeTypeIds) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("principal_id", principalId)).bind("privilege_type_id", privilegeTypeId)).bind("securable_id", securableId)).add();
            }
            int[] results = batch.execute();
            return Arrays.stream(results).anyMatch(value -> value > 0);
        });
    }

    @Override
    public List<PrivilegeDetails> listAllPrivileges() {
        return this.accessor.execute(handle -> handle.createQuery(SQL_LIST).map((rs, ctx) -> new PrivilegeDetails(this.accessor.getUuid(rs, "principal_id"), rs.getString("principal_name"), this.accessor.getUuid(rs, "securable_id"), this.accessor.getUuid(rs, "privilege_type_id"))).list());
    }

    @Override
    public List<PrivilegeTypeDetails> listAllPrivilegeTypes() {
        return this.accessor.execute(handle -> handle.createQuery(SQL_LIST_TYPES).map((rs, ctx) -> new PrivilegeTypeDetails(this.accessor.getUuid(rs, "privilege_type_id"), rs.getString("caption"))).list());
    }

    @Override
    public Optional<PrincipalInternalSecurable> resolvePrincipal(String principalName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_RESOLVE_PRINCIPAL).bind("principal_name", principalName)).map((rs, ctx) -> new PrincipalInternalSecurable(new SecurableItem(this.accessor.getUuid(rs, "principal_id"), this.accessor.getOptionalUuid(rs, "owner_id"), principalName))).findOne());
    }

    @Override
    public Optional<FileSystemInternalSecurable> resolveFileSystem(String fileSystemName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_RESOLVE_FILE_SYSTEM).bind("file_system_name", fileSystemName)).map((rs, ctx) -> new FileSystemInternalSecurable(new SecurableItem(this.accessor.getUuid(rs, "file_system_id"), this.accessor.getOptionalUuid(rs, "owner_id"), fileSystemName))).findOne());
    }

    @Override
    public Optional<CatalogInternalSecurable> resolveCatalog(String catalogName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_RESOLVE_CATALOG).bind("catalog_name", catalogName)).map((rs, ctx) -> new CatalogInternalSecurable(this.toCatalogItem(catalogName, rs))).findOne());
    }

    @Override
    public Optional<NamespaceInternalSecurable> resolveNamespace(String catalogName, String namespaceName) {
        return this.accessor.execute(handle -> ((Query)((Query)handle.createQuery(SQL_RESOLVE_NAMESPACE).bind("catalog_name", catalogName)).bind("namespace_name", namespaceName)).map((rs, ctx) -> new NamespaceInternalSecurable(this.toCatalogItem(catalogName, rs), this.toNamespaceItem(namespaceName, rs))).findOne());
    }

    @Override
    public Optional<ObjectInternalSecurable> resolveTable(String catalogName, String namespaceName, String tableName) {
        return this.resolveObject(catalogName, namespaceName, tableName, SecurableType.SECURABLE_TYPE_TABLE);
    }

    @Override
    public Optional<ObjectInternalSecurable> resolveView(String catalogName, String namespaceName, String viewName) {
        return this.resolveObject(catalogName, namespaceName, viewName, SecurableType.SECURABLE_TYPE_VIEW);
    }

    @Override
    public Optional<ObjectInternalSecurable> resolveMaterializedView(String catalogName, String namespaceName, String materializedViewName) {
        return this.resolveObject(catalogName, namespaceName, materializedViewName, SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW);
    }

    @Override
    public Optional<SecurityProviderInternalSecurable> resolveSecurityProvider(String securityProviderName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_RESOLVE_SECURITY_PROVIDER).bind("provider_name", securityProviderName)).map((rs, ctx) -> new SecurityProviderInternalSecurable(new SecurableItem(this.accessor.getUuid(rs, "provider_id"), Optional.of(this.accessor.getUuid(rs, "owner_id")), securityProviderName))).findOne());
    }

    private Optional<ObjectInternalSecurable> resolveObject(String catalogName, String namespaceName, String objectName, SecurableType objectType) {
        IcebergTableType tableType = switch (objectType) {
            case SecurableType.SECURABLE_TYPE_TABLE, SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW -> IcebergTableType.TABLE;
            case SecurableType.SECURABLE_TYPE_VIEW -> IcebergTableType.VIEW;
            default -> throw new IllegalArgumentException("Unexpected securable type: " + String.valueOf((Object)objectType));
        };
        boolean mv = switch (objectType) {
            case SecurableType.SECURABLE_TYPE_TABLE, SecurableType.SECURABLE_TYPE_VIEW -> false;
            case SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW -> true;
            default -> throw new IllegalArgumentException("Unexpected securable type: " + String.valueOf((Object)objectType));
        };
        return this.accessor.execute(handle -> ((Query)((Query)((Query)((Query)((Query)handle.createQuery(SQL_RESOLVE_OBJECT).bind("catalog_name", catalogName)).bind("namespace_name", namespaceName)).bind("table_name", objectName)).bind("table_type", tableType.identifier())).bind("mv", mv ? 1 : 0)).map((rs, ctx) -> new ObjectInternalSecurable(objectType, this.toCatalogItem(catalogName, rs), this.toNamespaceItem(namespaceName, rs), this.toObjectItem(objectName, rs))).findOne());
    }

    private SecurableItem toCatalogItem(String catalogName, ResultSet rs) throws SQLException {
        return new SecurableItem(this.accessor.getUuid(rs, "catalog_id"), this.accessor.getOptionalUuid(rs, "catalog_owner_id"), catalogName);
    }

    private SecurableItem toNamespaceItem(String namespaceName, ResultSet rs) throws SQLException {
        return new SecurableItem(this.accessor.getUuid(rs, "namespace_id"), this.accessor.getOptionalUuid(rs, "namespace_owner_id"), namespaceName);
    }

    private SecurableItem toObjectItem(String objectName, ResultSet rs) throws SQLException {
        return new SecurableItem(this.accessor.getUuid(rs, "object_id"), this.accessor.getOptionalUuid(rs, "object_owner_id"), objectName);
    }

    @Override
    public Optional<ObjectGroupInternalSecurable> resolveObjectGroup(String objectGroupName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_RESOLVE_OBJECT_GROUP).bind("group_name", objectGroupName)).map((rs, ctx) -> new ObjectGroupInternalSecurable(new SecurableItem(this.accessor.getUuid(rs, "group_id"), this.accessor.getOptionalUuid(rs, "owner_id"), objectGroupName))).findOne());
    }

    @Override
    public Optional<ComputeEngineInternalSecurable> resolveComputeEngine(String computeEngineName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_RESOLVE_COMPUTE_ENGINE).bind("engine_name", computeEngineName)).map((rs, ctx) -> new ComputeEngineInternalSecurable(new SecurableItem(this.accessor.getUuid(rs, "engine_id"), this.accessor.getOptionalUuid(rs, "owner_id"), computeEngineName))).findOne());
    }

    @Override
    public Optional<JobInternalSecurable> resolveJob(String jobName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_RESOLVE_JOB).bind("job_name", jobName)).map((rs, ctx) -> this.toJobSecurable(jobName, rs.getString("engine_name"), rs)).findOne());
    }

    @Override
    public Optional<JobInternalSecurable> resolveJob(String computeEngineName, String jobName) {
        return this.accessor.execute(handle -> ((Query)((Query)handle.createQuery(SQL_RESOLVE_JOB_WITH_COMPUTE_ENGINE).bind("engine_name", computeEngineName)).bind("job_name", jobName)).map((rs, ctx) -> this.toJobSecurable(jobName, computeEngineName, rs)).findOne());
    }

    private JobInternalSecurable toJobSecurable(String jobName, String computeEngineName, ResultSet rs) throws SQLException {
        return new JobInternalSecurable(new SecurableItem(this.accessor.getUuid(rs, "engine_id"), this.accessor.getOptionalUuid(rs, "engine_owner_id"), computeEngineName), new SecurableItem(this.accessor.getUuid(rs, "job_id"), this.accessor.getOptionalUuid(rs, "job_owner_id"), jobName));
    }

    @Override
    public List<PrivilegeGrantInfo> listPrincipalGrants(Set<UUID> principalIds) {
        Verify.verify((!principalIds.isEmpty() ? 1 : 0) != 0, (String)"Role IDs cannot be empty", (Object[])new Object[0]);
        StringJoiner principalIdJoiner = new StringJoiner(", ", "p.principal_id IN (", ")");
        for (UUID roleId : principalIds) {
            principalIdJoiner.add("'" + String.valueOf(roleId) + "'");
        }
        String condition = principalIdJoiner.toString();
        return this.listGrants(condition);
    }

    @Override
    public List<PrivilegeGrantInfo> listSecurableGrants(Set<UUID> securableIds, Set<CatalogPrivilege> privileges) {
        Verify.verify((!securableIds.isEmpty() ? 1 : 0) != 0, (String)"Object IDs cannot be empty", (Object[])new Object[0]);
        Verify.verify((!privileges.isEmpty() ? 1 : 0) != 0, (String)"Privileges cannot be empty", (Object[])new Object[0]);
        StringJoiner securableIdJoiner = new StringJoiner(", ", "securable_id IN (", ")");
        for (UUID uUID : securableIds) {
            securableIdJoiner.add("'" + String.valueOf(uUID) + "'");
        }
        StringJoiner privilegeJoiner = new StringJoiner(", ", "privilege_type_id IN (", ")");
        for (CatalogPrivilege privilege : privileges) {
            privilegeJoiner.add("'" + String.valueOf(privilege.id()) + "'");
        }
        String string = String.valueOf(securableIdJoiner) + " AND " + String.valueOf(privilegeJoiner);
        return this.listGrants(string);
    }

    private List<PrivilegeGrantInfo> listGrants(String condition) {
        String sql = SQL_LIST_GRANTS.replace("{condition}", condition);
        return this.accessor.execute(handle -> handle.createQuery(sql).map((rs, ctx) -> this.toGrantInfo(rs)).list());
    }

    private PrivilegeGrantInfo toGrantInfo(ResultSet rs) throws SQLException {
        boolean metastore;
        String securityProviderName;
        String jobName;
        String computeEngineName;
        String objectGroupName;
        String objectName;
        String namespaceName;
        String catalogName;
        String fileSystemName;
        Securable.Builder securableBuilder = Securable.newBuilder();
        String principalName = rs.getString("securable_principal_name");
        if (principalName != null) {
            securableBuilder.setPrincipalName(principalName);
        }
        if ((fileSystemName = rs.getString("securable_file_system_name")) != null) {
            securableBuilder.setFileSystemName(fileSystemName);
        }
        if ((catalogName = rs.getString("securable_catalog_name")) != null) {
            securableBuilder.setCatalogName(catalogName);
        }
        if ((namespaceName = rs.getString("securable_namespace_name")) != null) {
            String namespaceCatalogName = rs.getString("securable_namespace_catalog_name");
            securableBuilder.setCatalogName(namespaceCatalogName).setNamespaceName(namespaceName);
        }
        if ((objectName = rs.getString("securable_object_name")) != null) {
            String objectNamespaceName = rs.getString("securable_object_namespace_name");
            String objectCatalogName = rs.getString("securable_object_catalog_name");
            securableBuilder.setCatalogName(objectCatalogName).setNamespaceName(objectNamespaceName);
            IcebergTableType objectType = IcebergTableType.resolve(rs.getInt("securable_object_type"));
            if (objectType == IcebergTableType.TABLE) {
                boolean objectMv;
                boolean bl = objectMv = rs.getShort("securable_object_mv") != 0;
                if (objectMv) {
                    securableBuilder.setMaterializedViewName(objectName);
                } else {
                    securableBuilder.setTableName(objectName);
                }
            } else {
                securableBuilder.setViewName(objectName);
            }
        }
        if ((objectGroupName = rs.getString("securable_object_group_name")) != null) {
            securableBuilder.setObjectGroupName(objectGroupName);
        }
        if ((computeEngineName = rs.getString("securable_compute_engine_name")) != null) {
            securableBuilder.setComputeEngineName(computeEngineName);
        }
        if ((jobName = rs.getString("securable_job_name")) != null) {
            String jobComputeEngineName = rs.getString("securable_job_compute_engine_name");
            securableBuilder.setComputeEngineName(jobComputeEngineName).setJobName(jobName);
        }
        if ((securityProviderName = rs.getString("securable_security_provider_name")) != null) {
            securableBuilder.setSecurityProviderName(securityProviderName);
        }
        if (metastore = MetastoreInternalSecurable.METASTORE_ID.equals(this.accessor.getUuid(rs, "securable_id"))) {
            securableBuilder.setMetastore(Boolean.valueOf(true));
        }
        return PrivilegeGrantInfo.newBuilder().setGranteeName(rs.getString("grantee_name")).setPrivilege(CatalogPrivilege.resolveById(this.accessor.getUuid(rs, "privilege_type_id")).caption()).setSecurable(securableBuilder.build()).build();
    }
}

