/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.iceberg.CedrusDataIcebergObjectType;
import ru.cedrusdata.catalog.iceberg.table.IcebergCteDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergCteTableForReuseResponseEx;
import ru.cedrusdata.catalog.iceberg.table.IcebergExpiredCteTable;
import ru.cedrusdata.catalog.iceberg.table.IcebergMaterializedViewDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergMaterializedViewForRewriteInfoEx;
import ru.cedrusdata.catalog.iceberg.table.IcebergMaterializedViewSnapshotDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectInfoEx;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectRestListResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectAlreadyExistsException;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteInfo;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.store.IcebergObjectStore;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorFactory;
import ru.cedrusdata.catalog.store.jdbc.PageSort;
import ru.cedrusdata.catalog.store.jdbc.QueryCondition;

@StoreTracingInterceptor.Traceable
public class JdbcIcebergObjectStore
implements IcebergObjectStore {
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_BY_NAME = "SELECT\n    c.catalog_id,\n    c.catalog_name,\n    c.owner_id catalog_owner_id,\n    n.namespace_id,\n    n.namespace_name,\n    n.owner_id namespace_owner_id,\n    t.table_id table_id,\n    t.table_name table_name,\n    t.owner_id table_owner_id,\n    p.principal_name table_owner_name,\n    t.table_type table_type,\n    t.mv,\n    t.metadata_location,\n    t.previous_metadata_location\nFROM metastore_iceberg_table t\n    INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n    LEFT OUTER JOIN metastore_principal p ON t.owner_id = p.principal_id\nWHERE n.catalog_id = :catalog_id AND t.table_name = :table_name AND t.namespace_id = :namespace_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_BY_ID = "SELECT\n    c.catalog_id,\n    c.catalog_name,\n    c.owner_id catalog_owner_id,\n    n.namespace_id,\n    n.namespace_name,\n    n.owner_id namespace_owner_id,\n    t.table_id table_id,\n    t.table_name table_name,\n    t.owner_id table_owner_id,\n    p.principal_name table_owner_name,\n    t.table_type table_type,\n    t.mv,\n    t.metadata_location,\n    t.previous_metadata_location\nFROM metastore_iceberg_table t\n    INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n    LEFT OUTER JOIN metastore_principal p ON t.owner_id = p.principal_id\nWHERE t.table_id = :table_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_LIST = "SELECT\n    c.catalog_id,\n    c.catalog_name,\n    c.owner_id catalog_owner_id,\n    n.namespace_id,\n    n.namespace_name,\n    n.owner_id namespace_owner_id,\n    t.table_id table_id,\n    t.table_name table_name,\n    t.owner_id table_owner_id,\n    p.principal_name table_owner_name,\n    t.table_type table_type,\n    t.mv,\n    t.metadata_location,\n    t.previous_metadata_location\nFROM metastore_iceberg_table t\n    INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n    LEFT OUTER JOIN metastore_principal p ON t.owner_id = p.principal_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_DETAILS = "SELECT\n    table_id,\n    owner_id,\n    metadata_location,\n    mv\nFROM metastore_iceberg_table\nWHERE namespace_id = :namespace_id AND table_name = :table_name AND table_type = :table_type\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_LIST_REST = "SELECT\n    c.catalog_id catalog_id,\n    c.catalog_name catalog_name,\n    c.owner_id catalog_owner_id,\n    n.namespace_id namespace_id,\n    n.namespace_name namespace_name,\n    n.owner_id namespace_owner_id,\n    t.table_id table_id,\n    t.table_name table_name,\n    t.owner_id table_owner_id\nFROM metastore_iceberg_table t\n    INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_CREATE = "INSERT INTO metastore_iceberg_table (\n    table_id,\n    table_name,\n    table_type,\n    owner_id,\n    namespace_id,\n    metadata_location,\n    mv)\nVALUES (\n    :table_id,\n    :table_name,\n    :table_type,\n    :owner_id,\n    :namespace_id,\n    :metadata_location,\n    :mv)\nON CONFLICT DO NOTHING\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_UPDATE = "UPDATE metastore_iceberg_table\nSET\n    metadata_location = :metadata_location,\n    previous_metadata_location = :previous_metadata_location\nWHERE table_id = :table_id AND table_name = :table_name AND table_type = :table_type AND namespace_id = :namespace_id AND metadata_location = :previous_metadata_location\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_UPDATE_OWNER = "UPDATE metastore_iceberg_table\nSET owner_id = :owner_id\nWHERE table_id = :table_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_RENAME = "UPDATE metastore_iceberg_table\nSET\n    namespace_id = :new_namespace_id,\n    table_name = :new_table_name\nWHERE table_id = :table_id AND table_name = :table_name AND table_type = :table_type AND namespace_id = :namespace_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_DELETE = "DELETE FROM metastore_iceberg_table\nWHERE table_id = :table_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_MV_SNAPSHOT_DELETE = "DELETE FROM metastore_iceberg_table_mv_snapshot\nWHERE table_id = :table_id";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_MV_SNAPSHOT_CREATE = "INSERT INTO metastore_iceberg_table_mv_snapshot (\n    table_id,\n    snapshot_id,\n    plan)\nVALUES (\n    :table_id,\n    :snapshot_id,\n    :plan)";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_MV_SNAPSHOT_REFERENCED_TABLE_CREATE = "INSERT INTO metastore_iceberg_table_mv_snapshot_referenced_table (\n    table_id,\n    snapshot_id,\n    referenced_table_name)\nVALUES (\n    :table_id,\n    :snapshot_id,\n    :referenced_table_name)";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_MATERIALIZED_VIEWS_FOR_REWRITE = "SELECT\n    n.namespace_id,\n    n.namespace_name,\n    n.owner_id namespace_owner_id,\n    t.table_id,\n    t.table_name,\n    t.owner_id table_owner_id,\n    mv_s.plan,\n    mv_s.snapshot_id\nFROM metastore_iceberg_table t\n    INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n    INNER JOIN metastore_iceberg_table_mv_snapshot mv_s ON t.table_id = mv_s.table_id\nWHERE\n    c.catalog_id = :catalog_id AND t.mv = 1 AND EXISTS (\n        SELECT mv_srt.table_id\n        FROM metastore_iceberg_table_mv_snapshot_referenced_table mv_srt\n        WHERE mv_srt.table_id = mv_s.table_id AND mv_srt.referenced_table_name IN ({referenced_table_names})\n    )\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_CTE_CREATE = "INSERT INTO metastore_iceberg_table_cte (\n    table_id,\n    canonical_plan,\n    canonical_plan_hash,\n    expires_at)\nVALUES (\n    :table_id,\n    :canonical_plan,\n    :canonical_plan_hash,\n    :expires_at)\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_CTE_UPDATE = "UPDATE metastore_iceberg_table_cte\nSET\n    canonical_plan = :canonical_plan,\n    canonical_plan_hash = :canonical_plan_hash,\n    expires_at = :expires_at\nWHERE table_id = :table_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_CTE_FOR_REUSE = "SELECT\n    c.catalog_name catalog_name,\n    c.owner_id catalog_owner_id,\n    n.namespace_id namespace_id,\n    n.namespace_name namespace_name,\n    n.owner_id namespace_owner_id,\n    t.table_id table_id,\n    t.table_name table_name,\n    t.owner_id table_owner_id\nFROM metastore_iceberg_table t\n    INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n    INNER JOIN metastore_iceberg_table_cte cte ON t.table_id = cte.table_id\nWHERE c.catalog_id = :catalog_id AND cte.expires_at >= :min_expires_at AND cte.canonical_plan_hash = :canonical_plan_hash AND cte.canonical_plan = :canonical_plan\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_EXPIRED_CTE_TABLES = "SELECT\n    c.catalog_name,\n    n.namespace_name,\n    t.table_name\nFROM metastore_iceberg_table t\n    INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n    INNER JOIN metastore_iceberg_table_cte cte ON t.table_id = cte.table_id\nWHERE c.catalog_id = :catalog_id AND cte.expires_at <= :current_time\n";
    private final JdbcAccessor accessor;
    private final PageProcessorFactory<IcebergObjectRestListResult.Entry> icebergTableListPageProcessorFactory;
    private final PageProcessorFactory<IcebergObjectInfoEx> icebergTableListForApiPageProcessorFactory;

    @Inject
    public JdbcIcebergObjectStore(JdbcAccessor accessor, CatalogStoreConfig config) {
        this.accessor = accessor;
        int maxPageSize = config.getStoreMaxPageSize();
        this.icebergTableListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_ICEBERG_TABLE_LIST_REST, PageSort.sort(PageSort.uuidSort("table_id", IcebergObjectRestListResult.Entry::objectId))), maxPageSize);
        this.icebergTableListForApiPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_ICEBERG_TABLE_LIST, PageSort.sort(PageSort.uuidSort("table_id", IcebergObjectInfoEx::objectId))), maxPageSize);
    }

    @Override
    public boolean createIfNotExist(UUID namespaceId, String tableName, IcebergTableType tableType, UUID ownerId, String metadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails, Optional<IcebergCteDetails> cteDetails) {
        UUID tableId = UUID.randomUUID();
        return this.accessor.execute(handle -> (Boolean)handle.inTransaction(txHandle -> {
            int updateCount = ((Update)((Update)((Update)((Update)((Update)((Update)((Update)txHandle.createUpdate(SQL_ICEBERG_TABLE_CREATE).bind("table_id", tableId)).bind("table_name", tableName)).bind("table_type", tableType.identifier())).bind("owner_id", ownerId)).bind("namespace_id", namespaceId)).bind("metadata_location", metadataLocation)).bind("mv", materializedViewDetails.isPresent() ? 1 : 0)).execute();
            if (updateCount == 0) {
                return false;
            }
            if (materializedViewDetails.isPresent()) {
                this.updateIcebergMaterializedView(txHandle, tableId, (IcebergMaterializedViewDetails)materializedViewDetails.get(), false);
            }
            if (cteDetails.isPresent()) {
                this.updateIcebergCte(txHandle, tableId, (IcebergCteDetails)cteDetails.get(), false);
            }
            return true;
        }));
    }

    @Override
    public boolean updateIfExists(UUID namespaceId, UUID tableId, String tableName, IcebergTableType tableType, String metadataLocation, String previousMetadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails, Optional<IcebergCteDetails> cteDetails) {
        return this.accessor.execute(handle -> (Boolean)handle.inTransaction(txHandle -> {
            int updateCount = ((Update)((Update)((Update)((Update)((Update)((Update)txHandle.createUpdate(SQL_ICEBERG_TABLE_UPDATE).bind("table_id", tableId)).bind("table_name", tableName)).bind("table_type", tableType.identifier())).bind("namespace_id", namespaceId)).bind("metadata_location", metadataLocation)).bind("previous_metadata_location", previousMetadataLocation)).execute();
            if (updateCount != 1) {
                return false;
            }
            if (materializedViewDetails.isPresent() || cteDetails.isPresent()) {
                if (materializedViewDetails.isPresent()) {
                    this.updateIcebergMaterializedView(txHandle, tableId, (IcebergMaterializedViewDetails)materializedViewDetails.get(), true);
                }
                if (cteDetails.isPresent()) {
                    this.updateIcebergCte(txHandle, tableId, (IcebergCteDetails)cteDetails.get(), true);
                }
            }
            return true;
        }));
    }

    private void updateIcebergMaterializedView(Handle handle, UUID tableId, IcebergMaterializedViewDetails mv, boolean delete) {
        if (delete) {
            ((Update)handle.createUpdate(SQL_ICEBERG_TABLE_MV_SNAPSHOT_DELETE).bind("table_id", tableId)).execute();
        }
        if (mv.snapshot().isPresent()) {
            IcebergMaterializedViewSnapshotDetails mvSnapshot = mv.snapshot().get();
            ((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_TABLE_MV_SNAPSHOT_CREATE).bind("table_id", tableId)).bind("snapshot_id", mvSnapshot.snapshotId())).bind("plan", mvSnapshot.plan())).execute();
            if (!mvSnapshot.referencedTables().isEmpty()) {
                PreparedBatch batch = handle.prepareBatch(SQL_ICEBERG_TABLE_MV_SNAPSHOT_REFERENCED_TABLE_CREATE);
                for (String referencedTable : mvSnapshot.referencedTables()) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("table_id", tableId)).bind("snapshot_id", mvSnapshot.snapshotId())).bind("referenced_table_name", referencedTable)).add();
                }
                batch.execute();
            }
        }
    }

    private void updateIcebergCte(Handle handle, UUID tableId, IcebergCteDetails cte, boolean update) {
        String canonicalPlanHash;
        String canonicalPlan = cte.canonicalPlan().orElse(null);
        String string = canonicalPlanHash = canonicalPlan != null ? JdbcIcebergObjectStore.getCanonicalPlanHash(canonicalPlan) : null;
        if (update) {
            ((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_TABLE_CTE_UPDATE).bind("table_id", tableId)).bind("canonical_plan", canonicalPlan)).bind("canonical_plan_hash", canonicalPlanHash)).bind("expires_at", cte.expiresAt())).execute();
        } else {
            ((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_TABLE_CTE_CREATE).bind("table_id", tableId)).bind("canonical_plan", canonicalPlan)).bind("canonical_plan_hash", canonicalPlanHash)).bind("expires_at", cte.expiresAt())).execute();
        }
    }

    @Override
    public boolean renameIfExists(String catalogName, UUID sourceNamespaceId, String sourceTableName, UUID sourceTableId, String destinationNamespaceName, UUID destinationNamespaceId, String destinationTableName, IcebergTableType objectType) {
        try {
            return this.accessor.execute(handle -> {
                int updateCount = ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_TABLE_RENAME).bind("table_id", sourceTableId)).bind("table_name", sourceTableName)).bind("table_type", objectType.identifier())).bind("namespace_id", sourceNamespaceId)).bind("new_namespace_id", destinationNamespaceId)).bind("new_table_name", destinationTableName)).execute();
                return updateCount == 1;
            });
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new IcebergObjectAlreadyExistsException(destinationNamespaceName, destinationTableName);
            }
            throw e;
        }
    }

    @Override
    public boolean deleteIfExists(UUID objectId) {
        return this.accessor.execute(handle -> {
            int updateCount = ((Update)handle.createUpdate(SQL_ICEBERG_TABLE_DELETE).bind("table_id", objectId)).execute();
            return updateCount == 1;
        });
    }

    @Override
    public Optional<IcebergObjectDetails> details(UUID namespaceId, String tableName, IcebergTableType tableType) {
        return this.accessor.execute(handle -> ((Query)((Query)((Query)handle.createQuery(SQL_ICEBERG_TABLE_DETAILS).bind("namespace_id", namespaceId)).bind("table_name", tableName)).bind("table_type", tableType.identifier())).map((rs, ctx) -> new IcebergObjectDetails(this.accessor.getUuid(rs, "table_id"), this.accessor.getUuid(rs, "owner_id"), rs.getString("metadata_location"), rs.getShort("mv") != 0)).findOne());
    }

    @Override
    public IcebergObjectRestListResult restList(UUID namespaceId, IcebergTableType type, ResultPage page, Predicate<IcebergObjectRestListResult.Entry> predicate) {
        return this.icebergTableListPageProcessorFactory.list(this.accessor, page, (pageProcessor, handle) -> pageProcessor.createQuery((Handle)handle, List.of(QueryCondition.eq("t.namespace_id", namespaceId), QueryCondition.eq("t.table_type", type.identifier()), QueryCondition.sql("t.mv = 0"))), rs -> this.toRestListEntry(type, rs), predicate, IcebergObjectRestListResult::new);
    }

    private IcebergObjectRestListResult.Entry toRestListEntry(IcebergTableType tableType, ResultSet rs) throws SQLException {
        SecurableType securableType = switch (tableType) {
            default -> throw new MatchException(null, null);
            case IcebergTableType.TABLE -> SecurableType.SECURABLE_TYPE_TABLE;
            case IcebergTableType.VIEW -> SecurableType.SECURABLE_TYPE_VIEW;
        };
        return new IcebergObjectRestListResult.Entry(this.accessor.getUuid(rs, "catalog_id"), rs.getString("catalog_name"), this.accessor.getOptionalUuid(rs, "catalog_owner_id"), this.accessor.getUuid(rs, "namespace_id"), rs.getString("namespace_name"), this.accessor.getOptionalUuid(rs, "namespace_owner_id"), this.accessor.getUuid(rs, "table_id"), rs.getString("table_name"), this.accessor.getOptionalUuid(rs, "table_owner_id"), securableType);
    }

    @Override
    public IcebergObjectListResponse list(Optional<String> catalogName, Optional<String> namespaceName, Optional<CedrusDataIcebergObjectType> objectType, ResultPage page, Predicate<IcebergObjectInfoEx> predicate) {
        List<QueryCondition> conditions = this.prepareListConditions(catalogName, namespaceName, objectType);
        return this.icebergTableListForApiPageProcessorFactory.list(this.accessor, page, (pageProcessor, handle) -> pageProcessor.createQuery((Handle)handle, conditions), this::toInfo, predicate, (items, token) -> new IcebergObjectListResponse(items.stream().map(IcebergObjectInfoEx::info).toList(), token));
    }

    private List<QueryCondition> prepareListConditions(Optional<String> catalogName, Optional<String> namespaceName, Optional<CedrusDataIcebergObjectType> objectType) {
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        if (catalogName.isPresent()) {
            conditions.add(QueryCondition.eq("catalog_name", catalogName.get(), "catalog_name"));
        }
        if (namespaceName.isPresent()) {
            conditions.add(QueryCondition.eq("namespace_name", namespaceName.get(), "namespace_name"));
        }
        if (objectType.isPresent()) {
            switch (objectType.get()) {
                case TABLE: {
                    conditions.add(QueryCondition.eq("table_type", IcebergTableType.TABLE.identifier(), "table_type"));
                    conditions.add(QueryCondition.eq("mv", 0, "mv"));
                    break;
                }
                case VIEW: {
                    conditions.add(QueryCondition.eq("table_type", IcebergTableType.VIEW.identifier(), "table_type"));
                    break;
                }
                case CEDRUSDATA_MATERIALIZED_VIEW: {
                    conditions.add(QueryCondition.eq("table_type", IcebergTableType.TABLE.identifier(), "table_type"));
                    conditions.add(QueryCondition.eq("mv", 1, "mv"));
                    break;
                }
                default: {
                    throw new CatalogBadRequestException("Unsupported object type: " + String.valueOf(objectType.get()));
                }
            }
        }
        return conditions;
    }

    @Override
    public Optional<IcebergObjectInfoEx> infoByName(UUID catalogId, UUID namespaceId, String objectName) {
        return this.accessor.execute(handle -> ((Query)((Query)((Query)handle.createQuery(SQL_ICEBERG_TABLE_BY_NAME).bind("catalog_id", catalogId)).bind("namespace_id", namespaceId)).bind("table_name", objectName)).map((rs, ctx) -> this.toInfo(rs)).findOne());
    }

    @Override
    public Optional<IcebergObjectInfoEx> infoById(UUID objectId) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_ICEBERG_TABLE_BY_ID).bind("table_id", objectId)).map((rs, ctx) -> this.toInfo(rs)).findOne());
    }

    private IcebergObjectInfoEx toInfo(ResultSet rs) throws SQLException {
        boolean mv;
        IcebergTableType tableType = IcebergTableType.resolve(rs.getInt("table_type"));
        boolean bl = mv = rs.getShort("mv") != 0;
        CedrusDataIcebergObjectType type = tableType == IcebergTableType.TABLE ? (mv ? CedrusDataIcebergObjectType.CEDRUSDATA_MATERIALIZED_VIEW : CedrusDataIcebergObjectType.TABLE) : CedrusDataIcebergObjectType.VIEW;
        IcebergObjectInfo info = new IcebergObjectInfo(rs.getString("catalog_name"), rs.getString("namespace_name"), rs.getString("table_name"), type.caption(), rs.getString("table_owner_name"), rs.getString("metadata_location"), rs.getString("previous_metadata_location"));
        UUID catalogId = this.accessor.getUuid(rs, "catalog_id");
        Optional<UUID> catalogOwnerId = this.accessor.getOptionalUuid(rs, "catalog_owner_id");
        UUID namespaceId = this.accessor.getUuid(rs, "namespace_id");
        Optional<UUID> namespaceOwnerId = this.accessor.getOptionalUuid(rs, "namespace_owner_id");
        UUID objectId = this.accessor.getUuid(rs, "table_id");
        Optional<UUID> objectOwnerId = this.accessor.getOptionalUuid(rs, "table_owner_id");
        return new IcebergObjectInfoEx(info, catalogId, catalogOwnerId, namespaceId, namespaceOwnerId, objectId, objectOwnerId);
    }

    @Override
    public IcebergMaterializedViewForRewriteListResponse listMaterializedViewsForRewrite(UUID catalogId, Set<String> tableNames, Predicate<IcebergMaterializedViewForRewriteInfoEx> predicate) {
        if (tableNames.isEmpty()) {
            return new IcebergMaterializedViewForRewriteListResponse(List.of());
        }
        StringJoiner referencedTablesCondition = new StringJoiner(", ");
        for (int i = 0; i < tableNames.size(); ++i) {
            referencedTablesCondition.add(":table_" + i);
        }
        String sql = SQL_ICEBERG_MATERIALIZED_VIEWS_FOR_REWRITE.replace("{referenced_table_names}", referencedTablesCondition.toString());
        List items = this.accessor.execute(handle -> {
            Query query = (Query)handle.createQuery(sql).bind("catalog_id", catalogId);
            int i = 0;
            for (String tableName : tableNames) {
                query.bind("table_" + i++, tableName);
            }
            return query.map((rs, ctx) -> {
                IcebergMaterializedViewForRewriteInfo info = new IcebergMaterializedViewForRewriteInfo(rs.getString("namespace_name"), rs.getString("table_name"), rs.getString("plan"), Long.valueOf(rs.getLong("snapshot_id")));
                UUID namespaceId = this.accessor.getUuid(rs, "namespace_id");
                Optional<UUID> namespaceOwnerId = this.accessor.getOptionalUuid(rs, "namespace_owner_id");
                UUID mvId = this.accessor.getUuid(rs, "table_id");
                Optional<UUID> mvOwnerId = this.accessor.getOptionalUuid(rs, "table_owner_id");
                return new IcebergMaterializedViewForRewriteInfoEx(info, namespaceId, namespaceOwnerId, mvId, mvOwnerId);
            }).list();
        });
        return new IcebergMaterializedViewForRewriteListResponse(items.stream().filter(predicate).map(IcebergMaterializedViewForRewriteInfoEx::info).toList());
    }

    @Override
    public Optional<IcebergCteTableForReuseResponseEx> cteTableForReuse(UUID catalogId, String canonicalPlan, long minExpiresAt) {
        return this.accessor.execute(handle -> ((Query)((Query)((Query)((Query)handle.createQuery(SQL_ICEBERG_TABLE_CTE_FOR_REUSE).bind("catalog_id", catalogId)).bind("canonical_plan_hash", JdbcIcebergObjectStore.getCanonicalPlanHash(canonicalPlan))).bind("canonical_plan", canonicalPlan)).bind("min_expires_at", minExpiresAt)).map((rs, ctx) -> new IcebergCteTableForReuseResponseEx(catalogId, rs.getString("catalog_name"), this.accessor.getOptionalUuid(rs, "catalog_owner_id"), this.accessor.getUuid(rs, "namespace_id"), rs.getString("namespace_name"), this.accessor.getOptionalUuid(rs, "namespace_owner_id"), this.accessor.getUuid(rs, "table_id"), rs.getString("table_name"), this.accessor.getOptionalUuid(rs, "table_owner_id"))).findOne());
    }

    @Override
    public List<IcebergExpiredCteTable> expiredCteTables(UUID catalogId, long currentTime) {
        return this.accessor.execute(handle -> ((Query)((Query)handle.createQuery(SQL_ICEBERG_EXPIRED_CTE_TABLES).bind("catalog_id", catalogId)).bind("current_time", currentTime)).map((rs, ctx) -> new IcebergExpiredCteTable(rs.getString("catalog_name"), rs.getString("namespace_name"), rs.getString("table_name"))).list());
    }

    @Override
    public boolean updateOwnerIfExists(UUID objectId, UUID ownerId) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_ICEBERG_TABLE_UPDATE_OWNER).bind("table_id", objectId)).bind("owner_id", ownerId)).execute() == 1);
    }

    private static String getCanonicalPlanHash(String canonicalPlan) {
        return Integer.valueOf(canonicalPlan.hashCode()).toString();
    }
}

