/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import jakarta.annotation.PostConstruct;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.output.MigrateResult;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;
import ru.cedrusdata.catalog.store.NestedStoreException;
import ru.cedrusdata.catalog.store.jdbc.JdbcConnectionDetails;
import ru.cedrusdata.catalog.store.jdbc.SqlDialect;

public class JdbcAccessor {
    private static final Logger log = Logger.get(JdbcAccessor.class);
    private static final String SCHEMA = "cedrusdata_catalog";
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final SqlDialect sqlDialect;
    private final JdbcConnectionDetails connectionDetails;
    private final Jdbi jdbi;

    @Inject
    public JdbcAccessor(SqlDialect sqlDialect, JdbcConnectionDetails connectionDetails, ConnectionFactory connectionFactory) {
        this.sqlDialect = sqlDialect;
        this.connectionDetails = connectionDetails;
        this.jdbi = Jdbi.create((ConnectionFactory)connectionFactory);
        sqlDialect.customizeJdbi(this.jdbi);
    }

    @PostConstruct
    public void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            this.migrate();
        }
    }

    public void migrate() {
        log.info("Started Flyway migration");
        String location = String.format("/jdbc/%s", this.connectionDetails.databaseType().getResourcePrefix());
        FluentConfiguration flywayConfig = Flyway.configure().dataSource(this.connectionDetails.url(), (String)this.connectionDetails.user().orElse(null), (String)this.connectionDetails.password().orElse(null)).jdbcProperties(this.connectionDetails.propertiesAsMap()).locations(new String[]{location}).baselineOnMigrate(true).baselineVersion("0").target(MigrationVersion.LATEST).failOnMissingLocations(true);
        if (this.connectionDetails.supportSchemas()) {
            flywayConfig.schemas(new String[]{SCHEMA});
        }
        Flyway flyway = flywayConfig.load();
        MigrateResult migrations = flyway.migrate();
        log.info("Completed Flyway migration for %s", new Object[]{migrations.migrationsExecuted});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(Function<Handle, T> command) {
        try (Handle handle = this.jdbi.open();){
            Handle t = command.apply(this.withSchema(handle));
            return (T)t;
        }
        catch (NestedStoreException e) {
            throw e.getOriginalCause();
        }
        catch (Exception e) {
            throw new CatalogInternalServerErrorException(String.format("Failed to execute catalog store operation: %s", e.getMessage()), (Throwable)e);
        }
    }

    public void execute(Consumer<Handle> command) {
        this.execute((Handle handle) -> {
            command.accept((Handle)handle);
            return null;
        });
    }

    public boolean isConstraintViolationException(Throwable throwable) {
        while (!this.sqlDialect.isConstraintViolationException(throwable)) {
            Throwable cause = throwable.getCause();
            if (cause == null || cause == throwable) {
                return false;
            }
            throwable = cause;
        }
        return true;
    }

    public UUID getUuid(ResultSet rs, String columnLabel) throws SQLException {
        return this.sqlDialect.getUuid(rs, columnLabel);
    }

    public Optional<UUID> getOptionalUuid(ResultSet rs, String columnLabel) throws SQLException {
        return Optional.ofNullable(this.getUuid(rs, columnLabel));
    }

    public Long getLongOrNull(ResultSet rs, String columnLabel) throws SQLException {
        Long value = rs.getLong(columnLabel);
        if (rs.wasNull()) {
            value = null;
        }
        return value;
    }

    public String forUpdate(String sql) {
        return this.sqlDialect.forUpdate(sql);
    }

    private Handle withSchema(Handle handle) {
        Optional<String> setSchemaSql = this.connectionDetails.databaseType().getSetSchemaSql();
        if (setSchemaSql.isPresent()) {
            String setSchemaCommand = String.format(setSchemaSql.get(), SCHEMA);
            handle.execute(setSchemaCommand, new Object[0]);
        }
        return handle;
    }

    @VisibleForTesting
    public List<Map<String, Object>> dumpTable(String tableName) {
        return this.execute((Handle handle) -> this.dumpTable((Handle)handle, tableName));
    }

    @VisibleForTesting
    public List<Map<String, Object>> dumpTable(Handle handle, String tableName) {
        return handle.createQuery("SELECT * FROM " + tableName).mapToMap().stream().toList();
    }
}

