/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.security;

import java.security.Principal;
import java.util.Objects;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;

public class CatalogPrincipal
implements Principal {
    private final AuthenticationContext context;

    public CatalogPrincipal(AuthenticationContext context) {
        this.context = context;
    }

    public AuthenticationContext context() {
        return this.context;
    }

    @Override
    public String getName() {
        return this.context.subject().name();
    }

    @Override
    public String toString() {
        String subject = this.context.subject().name();
        if (this.context.isImpersonated()) {
            String actor = this.context.actor().name();
            return subject + " (via " + actor + ")";
        }
        return subject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogPrincipal that = (CatalogPrincipal)o;
        return Objects.equals(this.context, that.context());
    }

    @Override
    public int hashCode() {
        return this.context.hashCode();
    }
}

