/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.jaxrs;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.http.server.TheServlet;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.jaxrs.JaxrsResource;
import io.airlift.jaxrs.JaxrsResourceConfig;
import io.airlift.jaxrs.JsonMapper;
import io.airlift.jaxrs.SmileMapper;
import jakarta.servlet.Servlet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import ru.cedrusdata.catalog.config.CatalogConfig;
import ru.cedrusdata.catalog.server.jaxrs.CatalogJaxrsTracingModule;

public class CatalogJaxrsModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(Servlet.class).annotatedWith(TheServlet.class).to(Key.get(ServletContainer.class));
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(JsonMapper.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(SmileMapper.class);
        Multibinder.newSetBinder((Binder)binder, Object.class, JaxrsResource.class).permitDuplicates();
        this.install(ConditionalModule.conditionalModule(CatalogConfig.class, config -> config.getTelemetryEnabled().traceHttp(), (Module)new CatalogJaxrsTracingModule()));
    }

    @Provides
    public static ServletContainer createServletContainer(ResourceConfig resourceConfig) {
        return new ServletContainer(resourceConfig);
    }

    @Provides
    public static ResourceConfig createResourceConfig(@JaxrsResource Set<Object> jaxRsSingletons) {
        return new JaxrsResourceConfig(jaxRsSingletons).setProperties((Map)ImmutableMap.of((Object)"jersey.config.server.response.setStatusOverSendError", (Object)"true"));
    }

    @Provides
    @TheServlet
    public static Map<String, String> createTheServletParams() {
        return new HashMap<String, String>();
    }
}

