/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.jmx;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.openmetrics.MetricsConfig;
import io.airlift.openmetrics.types.Counter;
import io.airlift.openmetrics.types.Gauge;
import io.airlift.openmetrics.types.Metric;
import io.airlift.openmetrics.types.Summary;
import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeDistribution;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ManagedClass;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;

@Path(value="/metrics")
@ResourceType(value=ResourceType.Type.CATALOG_MANAGEMENT_READ)
@ResourceSecurity(value=ResourceSecurity.Type.AUTHENTICATED)
public class OpenMetricsResource {
    private static final Logger log = Logger.get(OpenMetricsResource.class);
    private static final String OPENMETRICS_CONTENT_TYPE = "application/openmetrics-text; version=1.0.0; charset=utf-8";
    private static final String ATTRIBUTE_SEPARATOR = "_ATTRIBUTE_";
    private static final String TYPE_SEPARATOR = "_TYPE_";
    private static final String NAME_SEPARATOR = "_NAME_";
    private static final Pattern METRIC_NAME_PATTERN = Pattern.compile("[a-zA-Z][\\w_]*");
    private static final CharMatcher NON_ALLOWED_LABEL_CHARACTERS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"_")).negate().precomputed();
    private final MBeanServer mbeanServer;
    private final MBeanExporter mbeanExporter;
    private final List<ObjectName> allMetricsObjectNames;
    private final Map<String, String> labels;

    @Inject
    public OpenMetricsResource(MBeanServer mbeanServer, MBeanExporter mbeanExporter, MetricsConfig metricsConfig, NodeInfo nodeInfo) {
        this.mbeanServer = Objects.requireNonNull(mbeanServer, "mbeanServer is null");
        this.mbeanExporter = Objects.requireNonNull(mbeanExporter, "mbeanExporter is null");
        this.allMetricsObjectNames = metricsConfig.getJmxObjectNames();
        this.labels = nodeInfo.getAnnotations();
    }

    @GET
    @Produces(value={"application/openmetrics-text; version=1.0.0; charset=utf-8"})
    public String getMetrics(@QueryParam(value="name[]") List<String> filter) {
        StringBuilder body = new StringBuilder();
        if (filter != null && !filter.isEmpty()) {
            for (String metricName : filter) {
                this.toMetricExposition(metricName).ifPresent(body::append);
            }
        } else {
            body.append(this.managedMetricExpositions());
            for (ObjectName metricObjectNames : this.allMetricsObjectNames) {
                body.append(this.jmxMetricExpositions(metricObjectNames));
            }
        }
        body.append("# EOF\n");
        return body.toString();
    }

    private Set<ObjectName> objectNamesFromMetricName(String metricName) throws MalformedObjectNameException {
        int nameStart = metricName.indexOf(NAME_SEPARATOR);
        int typeStart = metricName.indexOf(TYPE_SEPARATOR);
        int attributeStart = metricName.indexOf(ATTRIBUTE_SEPARATOR);
        String domain = nameStart != -1 ? metricName.substring(0, nameStart).replace("_", ".") : (typeStart != -1 ? metricName.substring(0, typeStart).replace("_", ".") : metricName.substring(0, attributeStart).replace("_", "."));
        StringBuilder objectNameBuilder = new StringBuilder(domain).append(":");
        if (nameStart != -1) {
            objectNameBuilder.append("name=").append(metricName, nameStart + NAME_SEPARATOR.length(), typeStart == -1 ? attributeStart : typeStart).append(",");
        }
        if (typeStart != -1) {
            objectNameBuilder.append("type=").append(metricName.substring(typeStart + TYPE_SEPARATOR.length(), attributeStart).replace("_", "$")).append(",");
        }
        return this.mbeanServer.queryNames(ObjectName.getInstance(objectNameBuilder.append("*").toString()), null);
    }

    private String attributeNameFromMetricName(String metricName) {
        int attributeNameStart = metricName.indexOf(ATTRIBUTE_SEPARATOR);
        if (attributeNameStart == -1) {
            throw new RuntimeException("Metric name invalid, no attribute separator %s".formatted(metricName));
        }
        return metricName.substring(attributeNameStart + ATTRIBUTE_SEPARATOR.length()).replace("_", ".");
    }

    private String mBeanNameToMetricName(ObjectName objectName, String attributeName) {
        if (objectName.getDomain().contains("_")) {
            log.warn("Unable to expose JMX metric with domain name %s, package names with underscores are unsupported.", new Object[]{objectName.getDomain()});
            throw new RuntimeException("Bad domain name %s".formatted(objectName.getDomain()));
        }
        StringBuilder metricNameBuilder = new StringBuilder("JMX_").append(objectName.getDomain());
        if (objectName.getKeyProperty("name") != null) {
            metricNameBuilder.append(NAME_SEPARATOR).append(objectName.getKeyProperty("name"));
        }
        if (objectName.getKeyProperty("type") != null) {
            metricNameBuilder.append(TYPE_SEPARATOR).append(objectName.getKeyProperty("type"));
        }
        metricNameBuilder.append(ATTRIBUTE_SEPARATOR).append(attributeName);
        String metricName = OpenMetricsResource.sanitizeMetricName(metricNameBuilder.toString());
        if (!METRIC_NAME_PATTERN.matcher(metricName).matches()) {
            log.warn("Calculated metric name has invalid characters %s skipping", new Object[]{metricName});
        }
        return metricName;
    }

    private Optional<String> toMetricExposition(String metricName) {
        if (metricName.startsWith("JMX_")) {
            String jmxMetricName = metricName.substring(4);
            try {
                String attributeName = this.attributeNameFromMetricName(jmxMetricName);
                return this.objectNamesFromMetricName(jmxMetricName).stream().map(objectName -> this.getMetric((ObjectName)objectName, attributeName, jmxMetricName, "")).flatMap(Optional::stream).map(Metric::getMetricExposition).findFirst();
            }
            catch (MalformedObjectNameException e) {
                log.warn((Throwable)e, "Unable to retrieve metric %s.", new Object[]{metricName});
                return Optional.empty();
            }
        }
        Stream<Metric> metricStream = this.getManagedMetricsStream();
        return metricStream.filter(metric -> metric.metricName().equals(metricName)).findFirst().map(Metric::getMetricExposition);
    }

    private Optional<Metric> getMetric(ObjectName objectName, String attributeName, String metricName, String description) {
        try {
            Object attributeValue = this.mbeanServer.getAttribute(objectName, attributeName);
            if (attributeValue == null) {
                return Optional.empty();
            }
            if (attributeValue instanceof Number) {
                return Optional.of(Gauge.from((String)metricName, (Number)((Number)attributeValue), this.labels, (String)description));
            }
            return Optional.empty();
        }
        catch (JMException ex) {
            log.debug((Throwable)ex, "Unable to get metric for ObjectName %s and Attribute %s.", new Object[]{objectName.getCanonicalName(), attributeName});
            return Optional.empty();
        }
    }

    private String inferAttributesForObjectName(ObjectName objectName) {
        StringBuilder expositions = new StringBuilder();
        try {
            MBeanInfo mbeanInfo = this.mbeanServer.getMBeanInfo(objectName);
            for (MBeanAttributeInfo mBeanAttributeInfo : mbeanInfo.getAttributes()) {
                String attributeName = mBeanAttributeInfo.getName();
                String description = mBeanAttributeInfo.getDescription();
                try {
                    if (CompositeData.class.getName().equals(mBeanAttributeInfo.getType())) {
                        CompositeData compositeData = (CompositeData)this.mbeanServer.getAttribute(objectName, attributeName);
                        CompositeType compositeType = compositeData.getCompositeType();
                        for (String key : compositeType.keySet()) {
                            String metricName = this.mBeanNameToMetricName(objectName, attributeName + "_" + key);
                            String metricDescription = description + " (" + compositeType.getDescription(key) + ")";
                            Object metricValue = compositeData.get(key);
                            if (!(metricValue instanceof Number)) continue;
                            Gauge metric = Gauge.from((String)metricName, (Number)((Number)metricValue), this.labels, (String)metricDescription);
                            expositions.append(metric.getMetricExposition());
                        }
                        continue;
                    }
                    String metricName = this.mBeanNameToMetricName(objectName, attributeName);
                    Optional<Metric> metric = this.getMetric(objectName, attributeName, metricName, description);
                    if (!metric.isPresent()) continue;
                    expositions.append(metric.get().getMetricExposition());
                }
                catch (Exception e) {
                    log.debug((Throwable)e, "Unable to get Metric for ObjectName %s and Attribute %s, skipping", new Object[]{objectName.getCanonicalName(), attributeName});
                }
            }
        }
        catch (InstanceNotFoundException | IntrospectionException | ReflectionException e) {
            log.debug((Throwable)e, "Unable to get MBeanInfo for object %s, skipping", new Object[]{objectName.getCanonicalName()});
        }
        return expositions.toString();
    }

    @VisibleForTesting
    static String sanitizeMetricName(String name) {
        return NON_ALLOWED_LABEL_CHARACTERS.collapseFrom((CharSequence)name, '_');
    }

    private List<Metric> getMetricsRecursively(String prefix, ManagedClass managedClass) {
        String metricName = OpenMetricsResource.sanitizeMetricName(prefix);
        ImmutableList.Builder metrics = ImmutableList.builder();
        for (String attributeName : managedClass.getAttributeNames()) {
            try {
                String metricAndAttribute = managedClass.isAttributeFlatten(attributeName) ? metricName : metricName + "_" + attributeName;
                String attributeDescription = managedClass.getAttributeDescription(attributeName);
                ManagedClass child = (ManagedClass)managedClass.getChildren().get(attributeName);
                if (child != null) {
                    Optional<Metric> metricFromTarget = this.getMetricFromTarget(child, metricAndAttribute, attributeDescription);
                    if (metricFromTarget.isPresent()) {
                        metrics.add((Object)metricFromTarget.get());
                        continue;
                    }
                    metrics.addAll(this.getMetricsRecursively(metricAndAttribute, child));
                    continue;
                }
                Object attributeValue = managedClass.invokeAttribute(attributeName);
                if (attributeValue instanceof Number) {
                    metrics.add((Object)Gauge.from((String)metricAndAttribute, (Number)((Number)attributeValue), this.labels, (String)attributeDescription));
                }
                if (!(attributeValue instanceof Boolean)) continue;
                metrics.add((Object)Gauge.from((String)metricAndAttribute, (Number)((Boolean)attributeValue != false ? 1 : 0), this.labels, (String)attributeDescription));
            }
            catch (ReflectiveOperationException e) {
                log.debug("Unable to invoke getter for managed attribute : " + attributeName);
            }
        }
        return metrics.build();
    }

    private Optional<Metric> getMetricFromTarget(ManagedClass managedClass, String metricName, String description) {
        Object target;
        try {
            target = managedClass.getTarget();
        }
        catch (IllegalStateException ignored) {
            return Optional.empty();
        }
        if (target instanceof CounterStat) {
            CounterStat counterStat = (CounterStat)target;
            return Optional.of(Counter.from((String)metricName, (CounterStat)counterStat, this.labels, (String)description));
        }
        if (target instanceof TimeDistribution) {
            TimeDistribution timeDistribution = (TimeDistribution)target;
            return Optional.of(Summary.from((String)metricName, (TimeDistribution)timeDistribution, this.labels, (String)description));
        }
        return Optional.empty();
    }

    private String jmxMetricExpositions(ObjectName initialObjectName) {
        StringBuilder stringBuilder = new StringBuilder();
        this.mbeanServer.queryNames(initialObjectName, null).forEach(objectName -> stringBuilder.append(this.inferAttributesForObjectName((ObjectName)objectName)));
        return stringBuilder.toString();
    }

    private Stream<Metric> getManagedMetricsStream() {
        Map managedClasses = this.mbeanExporter.getManagedClasses();
        return managedClasses.keySet().stream().map(objectName -> this.getMetricsRecursively((String)objectName, (ManagedClass)managedClasses.get(objectName))).flatMap(Collection::stream);
    }

    private String managedMetricExpositions() {
        StringBuilder builder = new StringBuilder();
        this.getManagedMetricsStream().forEach(metric -> builder.append(metric.getMetricExposition()));
        return builder.toString();
    }
}

