/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import com.google.common.base.Verify;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.view.BaseViewOperations;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewMetadataParser;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.security.authorization.Authorizer;
import ru.cedrusdata.catalog.core.security.authorization.AuthorizerObjectType;
import ru.cedrusdata.catalog.core.security.authorization.securable.NamespaceInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectInternalSecurable;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergFileIO;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.table.IcebergInternalTableService;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectExtendedDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataCache;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataUtils;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectCommitFailedException;

public class IcebergViewOperations
extends BaseViewOperations {
    private final Authorizer authorizer;
    private final IcebergInternalTableService tableService;
    private final IcebergTableMetadataCache tableMetadataCache;
    private final IcebergNamespaceContext namespaceContext;
    private final Optional<IcebergObjectExtendedDetails> targetObjectDetails;
    private final String viewName;
    private final CatalogIcebergFileIO io;
    private String committedMetadataLocation;

    public IcebergViewOperations(Authorizer authorizer, IcebergInternalTableService tableService, IcebergTableMetadataCache tableMetadataCache, IcebergNamespaceContext namespaceContext, Optional<IcebergObjectExtendedDetails> targetObjectDetails, String viewName, CatalogIcebergFileIO io) {
        this.authorizer = authorizer;
        this.tableService = tableService;
        this.tableMetadataCache = tableMetadataCache;
        this.namespaceContext = namespaceContext;
        this.targetObjectDetails = targetObjectDetails;
        this.viewName = viewName;
        this.io = io;
    }

    protected void doRefresh() {
        Optional<String> newMetadataLocation;
        Optional<String> optional = newMetadataLocation = this.committedMetadataLocation != null ? Optional.of(this.committedMetadataLocation) : this.targetObjectDetails.map(IcebergObjectExtendedDetails::metadataLocation);
        if (newMetadataLocation.isEmpty()) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchViewException("View does not exist: %s", new Object[]{TableIdentifier.of((String[])new String[]{this.namespaceContext.namespaceName(), this.viewName})});
            }
            this.disableRefresh();
        } else {
            this.refreshFromMetadataLocation(newMetadataLocation.get(), IcebergTableMetadataUtils::shouldRetryMetadataRead, 20, this::readMetadata);
        }
    }

    protected void refreshFromMetadataLocation(String newLocation) {
        throw new UnsupportedOperationException("Should not be called");
    }

    protected void refreshFromMetadataLocation(String newLocation, Predicate<Exception> shouldRetry, int numRetries) {
        throw new UnsupportedOperationException("Should not be called");
    }

    private ViewMetadata readMetadata(String metadataLocation) {
        return IcebergTableMetadataUtils.readMetadata(this.tableMetadataCache, this.namespaceContext, this.viewName, IcebergTableType.VIEW, (FileIO)this.io(), metadataLocation, ViewMetadataParser::fromJson);
    }

    protected void doCommit(ViewMetadata base, ViewMetadata metadata) {
        try {
            String newLocation = this.writeNewMetadataIfRequired(metadata);
            Optional<String> oldLocation = Optional.ofNullable(base == null ? null : base.metadataFileLocation());
            this.authorize(base == null);
            this.tableService.createOrUpdate(this.namespaceContext, this.targetObjectDetails.map(IcebergObjectExtendedDetails::objectId), this.viewName, AuthorizerObjectType.VIEW, newLocation, oldLocation, Optional.empty(), Optional.empty());
            this.committedMetadataLocation = newLocation;
        }
        catch (IcebergObjectAlreadyExistsException e) {
            throw new AlreadyExistsException(e.getMessage(), new Object[0]);
        }
        catch (IcebergObjectCommitFailedException e) {
            throw new CommitFailedException(e.getMessage(), new Object[0]);
        }
    }

    private void authorize(boolean create) {
        AuthenticatedPrincipal principal = this.namespaceContext.catalogContext().currentPrincipal();
        if (create) {
            NamespaceInternalSecurable namespaceSecurable = this.namespaceContext.toSecurable();
            this.authorizer.authorizeObjectCreate(principal, namespaceSecurable, AuthorizerObjectType.VIEW);
        } else {
            Verify.verify((boolean)this.targetObjectDetails.isPresent());
            ObjectInternalSecurable objectSecurable = this.targetObjectDetails.get().toSecurable(this.namespaceContext.toSecurable());
            this.authorizer.authorizeObjectAlter(principal, objectSecurable);
        }
    }

    protected String viewName() {
        return this.namespaceContext.catalogContext().catalogName() + "." + this.namespaceContext.namespaceName() + "." + this.viewName;
    }

    protected CatalogIcebergFileIO io() {
        return this.io;
    }
}

