/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiFunction;
import java.util.zip.GZIPInputStream;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.util.Tasks;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataCache;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;

public class IcebergTableMetadataUtils {
    private IcebergTableMetadataUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readMetadata(IcebergTableMetadataCache tableMetadataCache, IcebergNamespaceContext namespaceContext, String name, IcebergTableType type, FileIO io, String metadataLocation, BiFunction<String, JsonNode, T> jsonParserFunction) {
        try {
            InputFile file = io.newInputFile(metadataLocation);
            if (tableMetadataCache.enabled()) {
                TableMetadataParser.Codec codec = TableMetadataParser.Codec.fromFileName((String)file.location());
                String cacheKey = IcebergTableMetadataCache.createMetadataKey(namespaceContext.catalogContext().catalogId(), namespaceContext.namespaceId(), name, type, metadataLocation);
                byte[] metadataBytes = tableMetadataCache.withKeyLock(cacheKey, () -> {
                    byte[] cachedMetadataBytes = tableMetadataCache.getMetadata(cacheKey);
                    if (cachedMetadataBytes == null) {
                        try (SeekableInputStream stream = file.newStream();){
                            cachedMetadataBytes = stream.readAllBytes();
                        }
                        tableMetadataCache.putMetadata(cacheKey, cachedMetadataBytes);
                    }
                    return cachedMetadataBytes;
                });
                ByteArrayInputStream baos = new ByteArrayInputStream(metadataBytes);
                try (InputStream is = codec == TableMetadataParser.Codec.GZIP ? new GZIPInputStream(baos) : baos;){
                    JsonNode json = (JsonNode)JsonUtil.mapper().readValue(is, JsonNode.class);
                    String string = jsonParserFunction.apply(file.location(), json);
                    return (T)string;
                }
            }
            TableMetadataParser.Codec codec = TableMetadataParser.Codec.fromFileName((String)file.location());
            try (GZIPInputStream is = codec == TableMetadataParser.Codec.GZIP ? new GZIPInputStream((InputStream)file.newStream()) : file.newStream();){
                JsonNode json = (JsonNode)JsonUtil.mapper().readValue((InputStream)is, JsonNode.class);
                String string = jsonParserFunction.apply(file.location(), json);
                return (T)string;
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                throw new NotFoundException("Metadata file %s doesn't exist", new Object[]{metadataLocation});
            }
            throw new RuntimeIOException(e, "Failed to read metadata file %s: %s", new Object[]{metadataLocation, e.getMessage()});
        }
    }

    public static boolean shouldRetryMetadataRead(Exception e) {
        if (e instanceof Tasks.UnrecoverableException) {
            return false;
        }
        if (e instanceof NotFoundException) {
            return false;
        }
        if (e instanceof FileNotFoundException || e.getCause() instanceof FileNotFoundException) {
            return false;
        }
        return !(e instanceof ValidationException);
    }
}

