/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.weakref.jmx.Managed;
import ru.cedrusdata.catalog.config.CatalogCacheConfig;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;

public class IcebergTableMetadataCache {
    private static final int CACHE_ENTRY_INSTANCE_SIZE = SizeOf.instanceSize(AbstractMap.SimpleEntry.class);
    private final Optional<Cache<String, Object>> cache;
    private final Striped<Lock> keyLock = Striped.lock((int)64);
    private final LongAdder size = new LongAdder();

    @Inject
    public IcebergTableMetadataCache(CatalogCacheConfig config) {
        Objects.requireNonNull(config, "config");
        this.cache = this.buildCache(config.getCacheIcebergTableMetadataSize().toBytes(), config.getCacheIcebergTableMetadataTtl().toMillis());
    }

    @SuppressModernizer
    private Optional<Cache<String, Object>> buildCache(long maxSizeBytes, long ttlMillis) {
        if (maxSizeBytes == 0L || ttlMillis == 0L) {
            return Optional.empty();
        }
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumWeight(maxSizeBytes).weigher(IcebergTableMetadataCache::entryWeight).removalListener(notification -> this.addSize(-IcebergTableMetadataCache.entryWeight((String)notification.getKey(), notification.getValue()))).recordStats();
        if (ttlMillis > 0L) {
            cacheBuilder.expireAfterWrite(ttlMillis, TimeUnit.MILLISECONDS);
        }
        return Optional.of(cacheBuilder.build());
    }

    @VisibleForTesting
    public static int entryWeight(String key, Object value) {
        int keySize = (int)SizeOf.estimatedSizeOf((String)key);
        int valueSize = (int)(value instanceof byte[] ? SizeOf.sizeOfByteArray((int)((byte[])value).length) : (long)((IcebergObjectDetails)value).estimatedSize());
        return CACHE_ENTRY_INSTANCE_SIZE + keySize + valueSize;
    }

    public boolean enabled() {
        return this.cache.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withKeyLock(String key, KeyAction<T> action) throws IOException {
        Lock lock = (Lock)this.keyLock.get((Object)key);
        lock.lock();
        try {
            T t = action.run();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    byte[] getMetadata(String key) {
        return (byte[])this.get(key);
    }

    IcebergObjectDetails getDetails(String key) {
        return (IcebergObjectDetails)this.get(key);
    }

    private <T> T get(String key) {
        return (T)(this.cache.isPresent() ? this.cache.get().getIfPresent((Object)key) : null);
    }

    void putMetadata(String key, byte[] value) {
        this.put(key, value);
    }

    void putDetails(String key, IcebergObjectDetails value) {
        this.put(key, value);
    }

    private void put(String key, Object value) {
        if (this.cache.isEmpty()) {
            return;
        }
        try {
            this.cache.get().get((Object)key, () -> value);
            this.addSize(IcebergTableMetadataCache.entryWeight(key, value));
        }
        catch (ExecutionException e) {
            throw new CatalogInternalServerErrorException("Unexpected cache exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String createDetailsKey(UUID catalogId, UUID namespaceId, String objectName, IcebergTableType objectType) {
        return String.valueOf(catalogId) + "." + String.valueOf(namespaceId) + "." + objectName + "." + objectType.identifier();
    }

    public static String createMetadataKey(UUID catalogId, UUID namespaceId, String objectName, IcebergTableType objectType, String metadataLocation) {
        return IcebergTableMetadataCache.createDetailsKey(catalogId, namespaceId, objectName, objectType) + "/" + metadataLocation;
    }

    public void invalidate(String key) {
        if (this.cache.isEmpty()) {
            return;
        }
        this.cache.get().invalidate((Object)key);
    }

    public void invalidateCatalog(UUID catalogId) {
        String catalogIdStr = catalogId.toString();
        this.invalidateByPredicate(key -> key.contains(catalogIdStr));
    }

    public void invalidateNamespace(UUID namespaceId) {
        String namespaceIdStr = namespaceId.toString();
        this.invalidateByPredicate(key -> key.contains(namespaceIdStr));
    }

    private void invalidateByPredicate(Predicate<String> predicate) {
        if (this.cache.isEmpty()) {
            return;
        }
        HashSet<String> keysToInvalidate = new HashSet<String>();
        for (String key : this.cache.get().asMap().keySet()) {
            if (!predicate.test(key)) continue;
            keysToInvalidate.add(key);
        }
        this.cache.get().invalidateAll(keysToInvalidate);
    }

    private void addSize(int delta) {
        this.size.add(delta);
    }

    @Managed
    public long getRequestCount() {
        return this.cache.map(Cache::stats).map(CacheStats::requestCount).orElse(0L);
    }

    @Managed
    public long getHitCount() {
        return this.cache.map(Cache::stats).map(CacheStats::hitCount).orElse(0L);
    }

    @Managed
    public double getHitRate() {
        return this.cache.map(Cache::stats).map(CacheStats::hitRate).orElse(0.0);
    }

    @Managed
    public long getMissCount() {
        return this.cache.map(Cache::stats).map(CacheStats::missCount).orElse(0L);
    }

    @Managed
    public double getMissRate() {
        return this.cache.map(Cache::stats).map(CacheStats::missRate).orElse(0.0);
    }

    @Managed
    public long getEvictionCount() {
        return this.cache.map(Cache::stats).map(CacheStats::evictionCount).orElse(0L);
    }

    @Managed
    public long getSizeInBytes() {
        return this.size.longValue();
    }

    @Managed
    public long getEntryCount() {
        return this.cache.map(Cache::size).orElse(0L);
    }

    @FunctionalInterface
    public static interface KeyAction<T> {
        public T run() throws IOException;
    }
}

