/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.rest;

import com.google.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Optional;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClientFactory;
import ru.cedrusdata.catalog.iceberg.rest.AbstractIcebergResource;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;
import ru.cedrusdata.catalog.spi.client.ResultPage;

@ResourceType(value=ResourceType.Type.ICEBERG)
@ResourceSecurity(value=ResourceSecurity.Type.AUTHENTICATED)
@Path(value="/catalog/iceberg/v1")
public class IcebergNamespaceResource
extends AbstractIcebergResource {
    @Inject
    public IcebergNamespaceResource(EmbeddedInternalCatalogClientFactory clientFactory) {
        super(clientFactory);
    }

    @POST
    @Path(value="/{prefix}/namespaces")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createNamespace(@PathParam(value="prefix") String catalogName, CreateNamespaceRequest request, @Context SecurityContext securityContext) {
        catalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalogName);
        CreateNamespaceResponse response = this.createClient(securityContext).restIcebergCreateNamespace(catalogName, request);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="/{prefix}/namespaces/{namespace}/properties")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateProperties(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, UpdateNamespacePropertiesRequest request, @Context SecurityContext securityContext) {
        catalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalogName);
        Namespace namespace = CatalogObjectNameValidation.decodeIcebergNamespace(namespaceName);
        UpdateNamespacePropertiesResponse response = this.createClient(securityContext).restIcebergUpdateNamespaceProperties(catalogName, namespace, request);
        return Response.ok((Object)response).build();
    }

    @DELETE
    @Path(value="/{prefix}/namespaces/{namespace}")
    @Produces(value={"application/json"})
    public Response dropNamespace(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @Context SecurityContext securityContext) {
        catalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalogName);
        Namespace namespace = CatalogObjectNameValidation.decodeIcebergNamespace(namespaceName);
        this.createClient(securityContext).restIcebergDropNamespace(catalogName, namespace);
        return Response.noContent().build();
    }

    @HEAD
    @Path(value="/{prefix}/namespaces/{namespace}")
    @Produces(value={"application/json"})
    public Response namespaceExists(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @Context SecurityContext securityContext) {
        catalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalogName);
        Namespace namespace = CatalogObjectNameValidation.decodeIcebergNamespace(namespaceName);
        this.createClient(securityContext).restIcebergNamespaceExists(catalogName, namespace);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{prefix}/namespaces/{namespace}")
    @Produces(value={"application/json"})
    public Response loadNamespaceMetadata(@PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @Context SecurityContext securityContext) {
        catalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalogName);
        Namespace namespace = CatalogObjectNameValidation.decodeIcebergNamespace(namespaceName);
        GetNamespaceResponse response = this.createClient(securityContext).restIcebergLoadNamespaceMetadata(catalogName, namespace);
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="/{prefix}/namespaces")
    @Produces(value={"application/json"})
    public Response listNamespaces(@PathParam(value="prefix") String catalogName, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="parent") String parent, @Context SecurityContext securityContext) {
        catalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalogName);
        Optional<Namespace> parentNamespace = CatalogObjectNameValidation.decodeOptionalIcebergNamespace(parent);
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        ListNamespacesResponse response = this.createClient(securityContext).restIcebergListNamespaces(catalogName, parentNamespace, page);
        return Response.ok((Object)response).build();
    }
}

