/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.namespace;

import com.google.inject.Inject;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.security.authorization.Authorizer;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeInternalService;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerNamespacePredicate;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogContext;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergFileIOFactory;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceDetails;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceInfoEx;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespacePropertiesUpdateResult;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceRestListResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataCache;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogPropertyConflictException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergCatalogDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceDoesNotExistException;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceInfo;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.store.IcebergNamespaceStore;

public class IcebergNamespaceService {
    private final IcebergCatalogService icebergCatalogService;
    private final IcebergTableMetadataCache tableMetadataCache;
    private final IcebergNamespaceStore store;
    private final Authorizer authorizer;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final Lock lock = new ReentrantLock();
    private final ConcurrentHashMap<NamespaceKey, IcebergNamespaceDetails> namespaces = new ConcurrentHashMap();
    private final PrivilegeInternalService privilegeInternalService;

    @Inject
    public IcebergNamespaceService(IcebergCatalogService icebergCatalogService, IcebergTableMetadataCache tableMetadataCache, IcebergNamespaceStore store, Authorizer authorizer, PrivilegeInternalService privilegeInternalService) {
        this.icebergCatalogService = Objects.requireNonNull(icebergCatalogService, "icebergCatalogService");
        this.tableMetadataCache = Objects.requireNonNull(tableMetadataCache, "tableMetadataCache");
        this.store = Objects.requireNonNull(store, "store");
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer");
        this.privilegeInternalService = Objects.requireNonNull(privilegeInternalService, "privilegeInternalService");
    }

    @PostConstruct
    public void initialize() {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        this.lock.lock();
        try {
            for (IcebergNamespaceDetails info : this.store.listDetails()) {
                this.namespaces.put(new NamespaceKey(info.catalogId(), info.namespaceName()), info);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public IcebergNamespaceDetails restCreate(AuthenticatedPrincipal principal, String catalogName, String namespaceName, Map<String, String> properties) {
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        return this.icebergCatalogService.execute(principal, catalogName, (IcebergCatalogContext catalogContext) -> {
            this.lock.lock();
            try {
                this.authorizer.authorizeNamespaceCreate(principal, catalogContext.toSecurable());
                Map<String, String> normalizedProperties = IcebergNamespaceService.normalizeProperties(catalogContext, normalizedNamespaceName, properties);
                NamespaceKey key = new NamespaceKey(catalogContext.catalogId(), normalizedNamespaceName);
                if (this.namespaces.containsKey(key)) {
                    throw new IcebergNamespaceAlreadyExistsException(normalizedNamespaceName);
                }
                Optional<UUID> namespaceId = this.store.restCreateIfNotExists(normalizedNamespaceName, catalogContext.catalogId(), catalogContext.catalogName(), principal.id(), normalizedProperties);
                if (namespaceId.isEmpty()) {
                    throw new IcebergNamespaceAlreadyExistsException(normalizedNamespaceName);
                }
                IcebergNamespaceDetails details = new IcebergNamespaceDetails(namespaceId.get(), normalizedNamespaceName, catalogContext.catalogId(), Optional.of(principal.id()), normalizedProperties);
                this.namespaces.put(key, details);
                IcebergNamespaceDetails icebergNamespaceDetails = details;
                return icebergNamespaceDetails;
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    public IcebergNamespacePropertiesUpdateResult restUpdateProperties(AuthenticatedPrincipal currentPrincipal, String catalogName, String namespaceName, Map<String, String> updates, Collection<String> removals) {
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        if (removals != null) {
            for (String removal : removals) {
                if (!updates.containsKey(removal)) continue;
                throw new CatalogPropertyConflictException(removal);
            }
        }
        try {
            return this.icebergCatalogService.execute(currentPrincipal, catalogName, (IcebergCatalogContext catalogContext) -> {
                this.lock.lock();
                try {
                    NamespaceKey key = new NamespaceKey(catalogContext.catalogId(), normalizedNamespaceName);
                    IcebergNamespaceDetails details = this.namespaces.get(key);
                    if (details == null) {
                        throw IcebergNamespaceService.namespaceNotExists(normalizedNamespaceName);
                    }
                    this.authorizer.authorizeNamespaceAlter(currentPrincipal, details.toSecurable((IcebergCatalogContext)catalogContext));
                    HashSet<String> removed = new HashSet<String>();
                    Map<String, String> newProperties = new HashMap<String, String>();
                    if (details.properties() != null) {
                        newProperties.putAll(details.properties());
                    }
                    if (updates != null) {
                        newProperties.putAll(updates);
                    }
                    if (removals != null) {
                        for (String removal : removals) {
                            if (newProperties.remove(removal) == null) continue;
                            removed.add(removal);
                        }
                    }
                    newProperties = IcebergNamespaceService.normalizeProperties(catalogContext, normalizedNamespaceName, newProperties);
                    boolean updated = this.store.restUpdateProperties(details.namespaceId(), newProperties);
                    if (!updated) {
                        throw IcebergNamespaceService.namespaceNotExists(normalizedNamespaceName);
                    }
                    IcebergNamespaceDetails newDetails = new IcebergNamespaceDetails(details.namespaceId(), details.namespaceName(), details.catalogId(), details.ownerId(), newProperties);
                    this.namespaces.put(key, newDetails);
                    IcebergNamespacePropertiesUpdateResult icebergNamespacePropertiesUpdateResult = new IcebergNamespacePropertiesUpdateResult(updates != null ? new HashSet(updates.keySet()) : Set.of(), removed);
                    return icebergNamespacePropertiesUpdateResult;
                }
                finally {
                    this.lock.unlock();
                }
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergNamespaceService.namespaceNotExists(namespaceName);
        }
    }

    public void restDelete(AuthenticatedPrincipal principal, String catalogName, String namespaceName) {
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        try {
            this.icebergCatalogService.execute(principal, catalogName, (IcebergCatalogContext catalogContext) -> {
                this.lock.lock();
                try {
                    NamespaceKey key = new NamespaceKey(catalogContext.catalogId(), normalizedNamespaceName);
                    IcebergNamespaceDetails details = this.namespaces.get(key);
                    if (details == null) {
                        throw IcebergNamespaceService.namespaceNotExists(normalizedNamespaceName);
                    }
                    this.authorizer.authorizeNamespaceDrop(principal, details.toSecurable((IcebergCatalogContext)catalogContext));
                    boolean deleted = this.store.restDeleteIfExists(details.namespaceId(), normalizedNamespaceName, catalogContext.catalogName());
                    if (!deleted) {
                        throw IcebergNamespaceService.namespaceNotExists(normalizedNamespaceName);
                    }
                    this.namespaces.remove(key);
                    this.tableMetadataCache.invalidateNamespace(details.namespaceId());
                    this.privilegeInternalService.clearPrivileges();
                    Object var7_7 = null;
                    return var7_7;
                }
                finally {
                    this.lock.unlock();
                }
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergNamespaceService.namespaceNotExists(namespaceName);
        }
    }

    public GetNamespaceResponse restLoadMetadata(AuthenticatedPrincipal principal, String catalogName, String namespaceName) {
        IcebergNamespaceDetails details = this.get(principal, catalogName, namespaceName);
        return GetNamespaceResponse.builder().withNamespace(Namespace.of((String[])new String[]{details.namespaceName()})).setProperties(details.properties()).build();
    }

    public void restExists(AuthenticatedPrincipal principal, String catalogName, String namespaceName) {
        this.restLoadMetadata(principal, catalogName, namespaceName);
    }

    public ListNamespacesResponse restList(AuthenticatedPrincipal principal, String catalogName, Optional<String> parentNamespace, ResultPage page) {
        return this.icebergCatalogService.execute(principal, catalogName, (IcebergCatalogContext catalogContext) -> {
            if (parentNamespace.isPresent()) {
                this.restExists(principal, catalogName, (String)parentNamespace.get());
                return ListNamespacesResponse.builder().build();
            }
            AuthorizerNamespacePredicate authorizerPredicate = this.authorizer.authorizeNamespaceList(principal);
            IcebergNamespaceRestListResult result = this.store.restList(catalogContext.catalogId(), page, entry -> authorizerPredicate.test(entry.toSecurable((IcebergCatalogContext)catalogContext)));
            ListNamespacesResponse.Builder builder = ListNamespacesResponse.builder();
            for (IcebergNamespaceRestListResult.Entry namespace : result.namespaces()) {
                builder.add(Namespace.of((String[])new String[]{namespace.name()}));
            }
            if (result.token() != null) {
                builder.nextPageToken(result.token());
            }
            return builder.build();
        });
    }

    public IcebergNamespaceInfo info(AuthenticatedPrincipal principal, String catalogName, String namespaceName) {
        try {
            String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
            return this.icebergCatalogService.execute(principal, catalogName, (IcebergCatalogContext catalogContext) -> {
                Optional<IcebergNamespaceInfoEx> info = this.store.info(catalogContext.catalogId(), normalizedNamespaceName);
                if (info.isEmpty()) {
                    throw IcebergNamespaceService.namespaceNotExists(normalizedNamespaceName);
                }
                this.authorizer.authorizeNamespaceDescribe(principal, info.get().toSecurable());
                return info.get().info();
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergNamespaceService.namespaceNotExists(namespaceName);
        }
    }

    public IcebergNamespaceDetails get(AuthenticatedPrincipal principal, String catalogName, String namespaceName) {
        try {
            String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
            return this.icebergCatalogService.execute(principal, catalogName, (IcebergCatalogContext catalogContext) -> {
                NamespaceKey key = new NamespaceKey(catalogContext.catalogId(), normalizedNamespaceName);
                IcebergNamespaceDetails details = this.namespaces.get(key);
                if (details == null) {
                    throw IcebergNamespaceService.namespaceNotExists(normalizedNamespaceName);
                }
                this.authorizer.authorizeNamespaceDescribe(principal, details.toSecurable((IcebergCatalogContext)catalogContext));
                return details;
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergNamespaceService.namespaceNotExists(namespaceName);
        }
    }

    public IcebergNamespaceListResponse list(AuthenticatedPrincipal principal, Optional<String> catalogName, ResultPage page) {
        AuthorizerNamespacePredicate authorizerPredicate = this.authorizer.authorizeNamespaceList(principal);
        Predicate<IcebergNamespaceInfoEx> predicate = info -> authorizerPredicate.test(info.toSecurable());
        return this.store.list(catalogName.map(CatalogObjectNameValidation.VALIDATION_NAMESPACE::normalizeObjectName), page, predicate);
    }

    public boolean grantOwnership(AuthenticatedPrincipal principal, String catalogName, String namespaceName, AuthenticatedPrincipal newOwnerPrincipal) {
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        try {
            return this.icebergCatalogService.execute(principal, catalogName, (IcebergCatalogContext catalogContext) -> {
                NamespaceKey key = new NamespaceKey(catalogContext.catalogId(), normalizedNamespaceName);
                IcebergNamespaceDetails details = this.namespaces.get(key);
                if (details == null) {
                    throw IcebergNamespaceService.namespaceNotExists(normalizedNamespaceName);
                }
                this.authorizer.authorizeGrantOwnership(principal, details.toSecurable((IcebergCatalogContext)catalogContext));
                if (details.ownerId().equals(Optional.of(newOwnerPrincipal.id()))) {
                    return false;
                }
                boolean updated = this.store.updateOwnerIfExists(details.namespaceId(), newOwnerPrincipal.id());
                if (!updated) {
                    throw IcebergNamespaceService.namespaceNotExists(namespaceName);
                }
                IcebergNamespaceDetails newDetails = new IcebergNamespaceDetails(details.namespaceId(), details.namespaceName(), details.catalogId(), Optional.of(newOwnerPrincipal.id()), details.properties());
                this.namespaces.put(key, newDetails);
                return true;
            });
        }
        catch (IcebergCatalogDoesNotExistException e) {
            throw IcebergNamespaceService.namespaceNotExists(namespaceName);
        }
    }

    public <T> T execute(AuthenticatedPrincipal principal, String catalogName, String namespaceName, Function<IcebergNamespaceContext, T> action) {
        return (T)this.icebergCatalogService.execute(principal, catalogName, (IcebergCatalogContext icebergCatalogContext) -> this.execute((IcebergCatalogContext)icebergCatalogContext, namespaceName, action));
    }

    public <T> T execute(IcebergCatalogContext catalogContext, String namespaceName, Function<IcebergNamespaceContext, T> action) {
        IcebergNamespaceContext namespaceContext = this.contextForExecute(catalogContext, namespaceName);
        return action.apply(namespaceContext);
    }

    public <T> T executeWithIo(AuthenticatedPrincipal principal, String catalogName, String namespaceName, BiFunction<IcebergNamespaceContext, CatalogIcebergFileIOFactory, T> action) {
        return (T)this.icebergCatalogService.executeWithIo(principal, catalogName, (catalogContext, ioFactory) -> this.executeWithIo((IcebergCatalogContext)catalogContext, (CatalogIcebergFileIOFactory)ioFactory, namespaceName, action));
    }

    public <T> T executeWithIo(IcebergCatalogContext catalogContext, CatalogIcebergFileIOFactory ioFactory, String namespaceName, BiFunction<IcebergNamespaceContext, CatalogIcebergFileIOFactory, T> action) {
        IcebergNamespaceContext namespaceContext = this.contextForExecute(catalogContext, namespaceName);
        return action.apply(namespaceContext, ioFactory);
    }

    private IcebergNamespaceContext contextForExecute(IcebergCatalogContext catalogContext, String namespaceName) {
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        NamespaceKey key = new NamespaceKey(catalogContext.catalogId(), normalizedNamespaceName);
        IcebergNamespaceDetails details = this.namespaces.get(key);
        if (details == null) {
            throw IcebergNamespaceService.namespaceNotExists(normalizedNamespaceName);
        }
        return new IcebergNamespaceContext(catalogContext, details.namespaceId(), details.namespaceName(), details.ownerId());
    }

    private static Map<String, String> normalizeProperties(IcebergCatalogContext icebergCatalogContext, String namespaceName, Map<String, String> properties) {
        if (properties == null) {
            properties = Map.of();
        }
        if (!properties.containsKey("location")) {
            properties = new HashMap<String, String>(properties);
            properties.put("location", icebergCatalogContext.defaultLocationProvider().defaultRestNamespaceLocation(namespaceName));
        }
        return properties;
    }

    private static IcebergNamespaceDoesNotExistException namespaceNotExists(String namespaceName) {
        return new IcebergNamespaceDoesNotExistException(CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName));
    }

    private record NamespaceKey(UUID catalogId, String namespaceName) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamespaceKey that = (NamespaceKey)o;
            return this.namespaceName.equals(that.namespaceName) && this.catalogId.equals(that.catalogId);
        }

        @Override
        public int hashCode() {
            int result = this.catalogId.hashCode();
            result = 31 * result + this.namespaceName.hashCode();
            return result;
        }
    }
}

