/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.check;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheck;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckContext;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckResultStep;
import ru.cedrusdata.catalog.core.security.authorization.securable.InternalSecurable;

public class AuthorizationCompositeCheck
implements AuthorizationCheck {
    private final Type type;
    private final List<AuthorizationCheck> checks;

    static AuthorizationCompositeCheck and(List<AuthorizationCheck> checks) {
        return new AuthorizationCompositeCheck(Type.AND, checks);
    }

    static AuthorizationCompositeCheck or(List<AuthorizationCheck> checks) {
        return new AuthorizationCompositeCheck(Type.OR, checks);
    }

    private AuthorizationCompositeCheck(Type type, List<AuthorizationCheck> checks) {
        Verify.verify((checks.size() > 1 ? 1 : 0) != 0);
        this.type = type;
        this.checks = checks;
    }

    @Override
    public AuthorizationCheck prepare(InternalSecurable securable) {
        ArrayList<AuthorizationCheck> newChecks = new ArrayList<AuthorizationCheck>(this.checks.size());
        for (AuthorizationCheck check : this.checks) {
            AuthorizationCheck newCheck = check.prepare(securable);
            if (newCheck instanceof AuthorizationCompositeCheck) {
                AuthorizationCompositeCheck newCompositeCheck = (AuthorizationCompositeCheck)newCheck;
                if (newCompositeCheck.type == this.type) {
                    newChecks.addAll(newCompositeCheck.checks);
                    continue;
                }
            }
            newChecks.add(newCheck);
        }
        return new AuthorizationCompositeCheck(this.type, newChecks);
    }

    @Override
    public AuthorizationCheckResultStep check(AuthorizationCheckContext context) {
        ArrayList<AuthorizationCheckResultStep> children = new ArrayList<AuthorizationCheckResultStep>(this.checks.size());
        boolean result = switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AuthorizationCheckResultStep childResult;
                boolean andResult = true;
                for (AuthorizationCheck check : this.checks) {
                    childResult = check.check(context);
                    children.add(childResult);
                    if (childResult.allowed()) continue;
                    andResult = false;
                    if (!context.shortCircuit()) continue;
                    break;
                }
                yield andResult;
            }
            case 1 -> {
                AuthorizationCheckResultStep childResult;
                boolean orResult = false;
                for (AuthorizationCheck check : this.checks) {
                    childResult = check.check(context);
                    children.add(childResult);
                    if (!childResult.allowed()) continue;
                    orResult = true;
                    if (!context.shortCircuit()) continue;
                    break;
                }
                yield orResult;
            }
        };
        return new AuthorizationCheckResultStep(this, result, children);
    }

    @Override
    public String descriptor(InternalSecurable securable) {
        return this.type.caption();
    }

    public String toString() {
        return this.type.caption + "(" + String.valueOf(this.checks) + ")";
    }

    public static enum Type {
        AND("all"),
        OR("any");

        private final String caption;

        private Type(String caption) {
            this.caption = caption;
        }

        private String caption() {
            return this.caption;
        }
    }
}

