/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization;

import com.google.inject.Inject;
import ru.cedrusdata.catalog.core.principal.PredefinedRoleIds;
import ru.cedrusdata.catalog.core.principal.PrincipalRoleIdService;
import ru.cedrusdata.catalog.core.security.audit.AuditManager;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeInternalService;
import ru.cedrusdata.catalog.core.security.authorization.SystemAuthorizerServices;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckResult;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationPrivileges;

public class SystemAuthorizerServicesImpl
implements SystemAuthorizerServices {
    private final PrivilegeInternalService privilegeService;
    private final PredefinedRoleIds predefinedRoleIds;
    private final AuditManager auditManager;

    @Inject
    public SystemAuthorizerServicesImpl(PrincipalRoleIdService roleIdService, PrivilegeInternalService privilegeService, AuditManager auditManager) {
        this.privilegeService = privilegeService;
        this.predefinedRoleIds = new PredefinedRoleIds(roleIdService.adminRoleId(), roleIdService.icebergAdminRoleId(), roleIdService.publicRoleId());
        this.auditManager = auditManager;
    }

    @Override
    public AuthorizationPrivileges privileges() {
        return this.privilegeService.privileges();
    }

    @Override
    public PredefinedRoleIds predefinedRoleIds() {
        return this.predefinedRoleIds;
    }

    @Override
    public void logAuthorizationEvent(AuthorizationCheckResult result) {
        this.auditManager.logAuthorizationEvent(result);
    }
}

