/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization;

import com.google.common.base.Verify;
import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilege;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeDetails;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationPrivileges;
import ru.cedrusdata.catalog.core.security.authorization.securable.CatalogInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ComputeEngineInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.FileSystemInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.InternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.JobInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.MetastoreInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.NamespaceInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectGroupInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.PrincipalInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurityProviderInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.UnboundSecurableInfo;
import ru.cedrusdata.catalog.iceberg.CedrusDataIcebergObjectType;
import ru.cedrusdata.catalog.spi.exception.CatalogComputeEngineDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.CatalogFileSystemDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.CatalogMaintenanceJobDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.CatalogObjectGroupDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.CatalogPrincipalDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.CatalogSecurityProviderDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergCatalogDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectDoesNotExistException;
import ru.cedrusdata.catalog.spi.model.PrivilegeGrantInfo;
import ru.cedrusdata.catalog.store.PrivilegeStore;

public class PrivilegeInternalService {
    private final PrivilegeStore store;
    private final Lock lock = new ReentrantLock();
    private volatile AuthorizationPrivileges registry;

    @Inject
    public PrivilegeInternalService(PrivilegeStore store) {
        this.store = store;
    }

    public InternalSecurable bindSecurable(UnboundSecurableInfo securable) {
        return switch (securable.parentType()) {
            default -> throw new MatchException(null, null);
            case SecurableType.SECURABLE_TYPE_METASTORE -> this.bindMetastore();
            case SecurableType.SECURABLE_TYPE_PRINCIPAL -> this.bindPrincipal(securable.name(0));
            case SecurableType.SECURABLE_TYPE_FILE_SYSTEM -> this.bindFileSystem(securable.name(0));
            case SecurableType.SECURABLE_TYPE_CATALOG -> this.bindCatalog(securable.name(0));
            case SecurableType.SECURABLE_TYPE_NAMESPACE -> this.bindNamespace(securable.name(0), securable.name(1));
            case SecurableType.SECURABLE_TYPE_TABLE -> this.bindTable(securable.name(0), securable.name(1), securable.name(2));
            case SecurableType.SECURABLE_TYPE_VIEW -> this.bindView(securable.name(0), securable.name(1), securable.name(2));
            case SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW -> this.bindMaterializedView(securable.name(0), securable.name(1), securable.name(2));
            case SecurableType.SECURABLE_TYPE_OBJECT_GROUP -> this.bindObjectGroup(securable.name(0));
            case SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE -> this.bindComputeEngine(securable.name(0));
            case SecurableType.SECURABLE_TYPE_JOB -> {
                Verify.verify((securable.names().size() == 1 || securable.names().size() == 2 ? 1 : 0) != 0);
                if (securable.names().size() == 1) {
                    yield this.bindJob(securable.name(0));
                }
                yield this.bindJob(securable.name(0), securable.name(1));
            }
            case SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER -> this.bindSecurityProvider(securable.name(0));
        };
    }

    private MetastoreInternalSecurable bindMetastore() {
        return MetastoreInternalSecurable.METASTORE_SECURABLE;
    }

    private PrincipalInternalSecurable bindPrincipal(String principalName) {
        return this.store.resolvePrincipal(principalName).orElseThrow(() -> new CatalogPrincipalDoesNotExistException(principalName));
    }

    private FileSystemInternalSecurable bindFileSystem(String fileSystemName) {
        return this.store.resolveFileSystem(fileSystemName).orElseThrow(() -> new CatalogFileSystemDoesNotExistException(fileSystemName));
    }

    private CatalogInternalSecurable bindCatalog(String catalogName) {
        return this.store.resolveCatalog(catalogName).orElseThrow(() -> new IcebergCatalogDoesNotExistException(catalogName));
    }

    private NamespaceInternalSecurable bindNamespace(String catalogName, String namespaceName) {
        return this.store.resolveNamespace(catalogName, namespaceName).orElseThrow(() -> new IcebergNamespaceDoesNotExistException(namespaceName));
    }

    private ObjectInternalSecurable bindTable(String catalogName, String namespaceName, String tableName) {
        return this.store.resolveTable(catalogName, namespaceName, tableName).orElseThrow(() -> new IcebergObjectDoesNotExistException(namespaceName, tableName, Optional.of(CedrusDataIcebergObjectType.TABLE.caption())));
    }

    private ObjectInternalSecurable bindView(String catalogName, String namespaceName, String viewName) {
        return this.store.resolveView(catalogName, namespaceName, viewName).orElseThrow(() -> new IcebergObjectDoesNotExistException(namespaceName, viewName, Optional.of(CedrusDataIcebergObjectType.VIEW.caption())));
    }

    private ObjectInternalSecurable bindMaterializedView(String catalogName, String namespaceName, String materializedViewName) {
        return this.store.resolveMaterializedView(catalogName, namespaceName, materializedViewName).orElseThrow(() -> new IcebergObjectDoesNotExistException(namespaceName, materializedViewName, Optional.of(CedrusDataIcebergObjectType.CEDRUSDATA_MATERIALIZED_VIEW.caption())));
    }

    private ObjectGroupInternalSecurable bindObjectGroup(String objectGroupName) {
        return this.store.resolveObjectGroup(objectGroupName).orElseThrow(() -> new CatalogObjectGroupDoesNotExistException(objectGroupName));
    }

    private ComputeEngineInternalSecurable bindComputeEngine(String computeEngineName) {
        return this.store.resolveComputeEngine(computeEngineName).orElseThrow(() -> new CatalogComputeEngineDoesNotExistException(computeEngineName));
    }

    private JobInternalSecurable bindJob(String jobName) {
        return this.store.resolveJob(jobName).orElseThrow(() -> new CatalogMaintenanceJobDoesNotExistException(jobName));
    }

    private JobInternalSecurable bindJob(String computeEngine, String jobName) {
        return this.store.resolveJob(computeEngine, jobName).orElseThrow(() -> new CatalogMaintenanceJobDoesNotExistException(jobName));
    }

    public SecurityProviderInternalSecurable bindSecurityProvider(String securityProviderName) {
        return this.store.resolveSecurityProvider(securityProviderName).orElseThrow(() -> new CatalogSecurityProviderDoesNotExistException(securityProviderName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createPrivileges(UUID principalId, Set<CatalogPrivilege> privileges, InternalSecurable securable, UUID ownerId) {
        this.lock.lock();
        try {
            boolean res = this.store.createPrivileges(principalId, privileges.stream().map(CatalogPrivilege::id).collect(Collectors.toSet()), securable.id(), ownerId, securable.idIfTypeMatches(SecurableType.SECURABLE_TYPE_PRINCIPAL), securable.idIfTypeMatches(SecurableType.SECURABLE_TYPE_FILE_SYSTEM), securable.idIfTypeMatches(SecurableType.SECURABLE_TYPE_CATALOG), securable.idIfTypeMatches(SecurableType.SECURABLE_TYPE_NAMESPACE), securable.idIfTypeMatches(Set.of(SecurableType.SECURABLE_TYPE_TABLE, SecurableType.SECURABLE_TYPE_VIEW, SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW)), securable.idIfTypeMatches(SecurableType.SECURABLE_TYPE_OBJECT_GROUP), securable.idIfTypeMatches(SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE), securable.idIfTypeMatches(SecurableType.SECURABLE_TYPE_JOB), securable.idIfTypeMatches(SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER));
            if (res) {
                this.clearPrivileges();
            }
            boolean bl = res;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revokePrivileges(UUID principalId, Set<CatalogPrivilege> privileges, InternalSecurable securable) {
        this.lock.lock();
        try {
            boolean res = this.store.deletePrivileges(principalId, privileges.stream().map(CatalogPrivilege::id).collect(Collectors.toSet()), securable.id());
            if (res) {
                this.clearPrivileges();
            }
            boolean bl = res;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AuthorizationPrivileges privileges() {
        AuthorizationPrivileges res = this.registry;
        if (res == null) {
            this.lock.lock();
            try {
                res = this.registry;
                if (res == null) {
                    this.registry = res = this.readPrivileges();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return res;
    }

    private AuthorizationPrivileges readPrivileges() {
        AuthorizationPrivileges.Builder builder = new AuthorizationPrivileges.Builder();
        List<PrivilegeDetails> allPrivileges = this.store.listAllPrivileges();
        for (PrivilegeDetails privilegeDetails : allPrivileges) {
            CatalogPrivilege privilege = CatalogPrivilege.resolveById(privilegeDetails.privilegeId());
            builder.add(privilegeDetails.principalId(), privilegeDetails.securableId(), privilege);
        }
        return builder.build();
    }

    public void clearPrivileges() {
        this.lock.lock();
        try {
            this.registry = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<PrivilegeGrantInfo> listPrincipalGrants(Set<UUID> principalIds) {
        return this.store.listPrincipalGrants(principalIds);
    }

    public List<PrivilegeGrantInfo> listSecurableGrants(Set<UUID> securableIds, Set<CatalogPrivilege> privileges) {
        return this.store.listSecurableGrants(securableIds, privileges);
    }
}

