/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.resource;

import com.google.inject.Inject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import ru.cedrusdata.catalog.config.CatalogConfig;
import ru.cedrusdata.catalog.spi.CatalogResourceResolver;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;

public class ResourceResolverImpl
implements CatalogResourceResolver {
    private final Path basePath;

    @Inject
    public ResourceResolverImpl(CatalogConfig config) {
        this.basePath = ResourceResolverImpl.validateBasePath(Objects.requireNonNull(config, "config").getResourceDir().toPath());
    }

    public String resolveResourcePath(String pathStr, String description) {
        if (pathStr == null || pathStr.trim().isEmpty()) {
            throw new CatalogBadRequestException(String.format("%s path cannot be empty", description));
        }
        Path path = Path.of(pathStr, new String[0]);
        if (path.isAbsolute()) {
            throw new CatalogBadRequestException(String.format("%s path \"%s\" must be relative to resource dir (see \"resource-dir\" config)", description, pathStr));
        }
        Path resourcePath = this.basePath.resolve(path);
        if (!Files.exists(resourcePath, new LinkOption[0])) {
            throw new CatalogBadRequestException(String.format("%s path \"%s\" doesn't exist in resource dir (see \"resource-dir\" config)", description, pathStr));
        }
        return resourcePath.toAbsolutePath().toString();
    }

    private static Path validateBasePath(Path basePath) {
        if (Files.exists(basePath, new LinkOption[0]) && !Files.isDirectory(basePath, new LinkOption[0])) {
            throw new CatalogInternalServerErrorException(String.format("Resource dir path \"%s\" is not a directory", basePath));
        }
        return basePath;
    }
}

