/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.principal.cache;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.SizeOf;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;

public record PrincipalServiceCacheEntry(UUID id, String name, UUID ownerId, Set<UUID> roleIds, boolean isUser, String accessToken, UUID identifiedWith) {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(PrincipalServiceCacheEntry.class);
    private static final int UUID_INSTANCE_SIZE = SizeOf.instanceSize(UUID.class);

    public AuthenticatedPrincipal toPrincipal() {
        return new AuthenticatedPrincipal(this.id, this.name, Optional.ofNullable(this.ownerId), this.roleIds, this.isUser);
    }

    public int estimatedSize() {
        return (int)((long)(INSTANCE_SIZE + UUID_INSTANCE_SIZE) + SizeOf.estimatedSizeOf((String)this.name) + (long)UUID_INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.roleIds, v -> UUID_INSTANCE_SIZE) + SizeOf.estimatedSizeOf((String)this.accessToken) + (long)UUID_INSTANCE_SIZE);
    }

    @VisibleForTesting
    public PrincipalServiceCacheEntry withAccessToken(String accessToken) {
        return new PrincipalServiceCacheEntry(this.id, this.name, this.ownerId, this.roleIds, this.isUser, accessToken, this.identifiedWith);
    }
}

