/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.principal;

import com.google.inject.Inject;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;
import ru.cedrusdata.catalog.store.PrincipalStore;

public class PrincipalRoleIdService {
    public static final String ROLE_ADMIN = "builtin.admin";
    public static final String ROLE_ICEBERG_ADMIN = "builtin.iceberg.admin";
    public static final String ROLE_PUBLIC = "builtin.public";
    private final PrincipalStore store;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private volatile UUID adminRoleId;
    private volatile UUID icebergAdminRoleId;
    private volatile UUID publicRoleId;

    @Inject
    public PrincipalRoleIdService(PrincipalStore store) {
        this.store = store;
    }

    @PostConstruct
    public void initialize() {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        Map<String, UUID> allRoles = this.store.listRoles();
        this.adminRoleId = allRoles.get(ROLE_ADMIN);
        if (this.adminRoleId == null) {
            throw new CatalogInternalServerErrorException(String.format("%s role is not available", ROLE_ADMIN));
        }
        this.icebergAdminRoleId = allRoles.get(ROLE_ICEBERG_ADMIN);
        if (this.icebergAdminRoleId == null) {
            throw new CatalogInternalServerErrorException(String.format("%s role is not available", ROLE_ICEBERG_ADMIN));
        }
        this.publicRoleId = allRoles.get(ROLE_PUBLIC);
        if (this.publicRoleId == null) {
            throw new CatalogInternalServerErrorException(String.format("%s role is not available", ROLE_PUBLIC));
        }
    }

    public UUID adminRoleId() {
        return this.adminRoleId;
    }

    public UUID icebergAdminRoleId() {
        return this.icebergAdminRoleId;
    }

    public UUID publicRoleId() {
        return this.publicRoleId;
    }
}

