/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.principal;

import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.impl.DefaultJwtBuilder;
import io.jsonwebtoken.impl.DefaultJwtParserBuilder;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.jackson.io.JacksonDeserializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.security.Keys;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.Key;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import ru.cedrusdata.catalog.config.CatalogConfig;
import ru.cedrusdata.catalog.core.principal.JwtCredentials;

public class JwtTokenManager {
    private static final Logger logger = Logger.get(JwtTokenManager.class);
    private static final FileAttribute<?> JWT_KEY_FILE_ATTRIBUTES = PosixFilePermissions.asFileAttribute(Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
    private static final Serializer<Map<String, ?>> JWT_SERIALIZER = new JacksonSerializer();
    private static final Random SECURE_RANDOM = new SecureRandom();
    private static final int RANDOM_STATE_KEY_SIZE = 32;
    private static final String CLAIM_ACTOR = "cedrusdata-catalog-actor";
    private static final String ISSUER = "cedrusdata-catalog";
    private final Key subjectTokenJwtParserSigningKey;
    private final JwtParser subjectTokenJwtParser;

    @Inject
    public JwtTokenManager(CatalogConfig config) {
        this.subjectTokenJwtParserSigningKey = Keys.hmacShaKeyFor((byte[])this.resolveKey(config.getJwtStateKey(), config.getJwtGeneratedStateKeyPath()));
        this.subjectTokenJwtParser = new DefaultJwtParserBuilder().setSigningKey(this.subjectTokenJwtParserSigningKey).json((Deserializer)new JacksonDeserializer()).requireIssuer(ISSUER).build();
    }

    private byte[] resolveKey(Optional<String> configKey, File generatedKeyFile) {
        if (configKey.isPresent()) {
            return Hashing.sha256().hashString((CharSequence)configKey.get(), StandardCharsets.UTF_8).asBytes();
        }
        Path generatedKeyPath = generatedKeyFile.toPath();
        try {
            return Files.readAllBytes(generatedKeyPath);
        }
        catch (IOException iOException) {
            byte[] key = JwtTokenManager.randomStateKey();
            try {
                Files.deleteIfExists(generatedKeyPath);
                Files.createFile(generatedKeyPath, JWT_KEY_FILE_ATTRIBUTES);
                Files.write(generatedKeyPath, key, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                logger.warn((Throwable)e, "Failed to save generated JWT key (existing JWT token will not work after restart)");
            }
            return key;
        }
    }

    public String wrapCredentials(JwtCredentials credentials, int expiration) {
        Instant now = Instant.now();
        return new DefaultJwtBuilder().signWith(this.subjectTokenJwtParserSigningKey).json(JWT_SERIALIZER).subject(credentials.subject()).claim(CLAIM_ACTOR, (Object)credentials.actor()).issuer(ISSUER).issuedAt(Date.from(now)).expiration(Date.from(now.plusSeconds(expiration))).compact();
    }

    public Optional<JwtCredentials> unwrapCredentials(String token) {
        try {
            Claims payload = (Claims)this.subjectTokenJwtParser.parseSignedClaims((CharSequence)token).getPayload();
            String subject = payload.getSubject();
            if (subject == null) {
                return Optional.empty();
            }
            String actor = (String)payload.get(CLAIM_ACTOR, String.class);
            if (actor == null) {
                return Optional.empty();
            }
            return Optional.of(new JwtCredentials(actor, subject));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static byte[] randomStateKey() {
        byte[] bytes = new byte[32];
        SECURE_RANDOM.nextBytes(bytes);
        return bytes;
    }
}

