/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.objectgroup;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationObject;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupDetails;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupObjectDetails;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupObjectDetailsListResult;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupObjectDetailsListResultForMaintenance;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupTarget;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.security.authorization.Authorizer;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeInternalService;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerObjectGroupPredicate;
import ru.cedrusdata.catalog.core.security.authorization.predicate.AuthorizerObjectPredicate;
import ru.cedrusdata.catalog.iceberg.CedrusDataIcebergObjectType;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogContext;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceService;
import ru.cedrusdata.catalog.iceberg.table.IcebergInternalTableService;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectDetails;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogObjectGroupAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.CatalogObjectGroupDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.CatalogObjectGroupItemDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectDoesNotExistException;
import ru.cedrusdata.catalog.spi.model.ObjectGroupCreateRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupInfo;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemAddRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupObjectListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupUpdateRequest;
import ru.cedrusdata.catalog.store.ObjectGroupStore;

public class ObjectGroupService {
    private final Authorizer authorizer;
    private final IcebergCatalogService catalogService;
    private final IcebergNamespaceService namespaceService;
    private final IcebergInternalTableService tableService;
    private final ObjectGroupStore store;
    private final PrivilegeInternalService privilegeInternalService;
    private final Lock lock = new ReentrantLock();

    @Inject
    public ObjectGroupService(Authorizer authorizer, IcebergCatalogService catalogService, IcebergNamespaceService namespaceService, IcebergInternalTableService tableService, ObjectGroupStore store, PrivilegeInternalService privilegeInternalService) {
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer");
        this.catalogService = Objects.requireNonNull(catalogService, "catalogService");
        this.namespaceService = Objects.requireNonNull(namespaceService, "namespaceService");
        this.tableService = Objects.requireNonNull(tableService, "tableService");
        this.store = Objects.requireNonNull(store, "store");
        this.privilegeInternalService = Objects.requireNonNull(privilegeInternalService, "privilegeInternalService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(AuthenticatedPrincipal principal, ObjectGroupCreateRequest request) {
        String normalizedObjectGroupName = CatalogObjectNameValidation.VALIDATION_OBJECT_GROUP.normalizeObjectName(request.getGroupName());
        String catalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.normalizeObjectName(request.getCatalogName());
        this.authorizer.authorizeObjectGroupCreate(principal);
        this.lock.lock();
        try {
            this.catalogService.execute(principal, catalogName, catalogContext -> {
                Optional<ObjectGroupTarget> target = this.resolveTarget((IcebergCatalogContext)catalogContext, request.getNamespaceName(), request.getObjectName());
                boolean created = this.store.createIfNotExists(normalizedObjectGroupName, catalogContext.catalogId(), principal.id(), request.getDescription(), target);
                if (!created) {
                    throw new CatalogObjectGroupAlreadyExistsException(normalizedObjectGroupName);
                }
                return null;
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(AuthenticatedPrincipal principal, String objectGroupName, ObjectGroupUpdateRequest request) {
        if (request.getGroupName() == null && request.getDescription() == null) {
            throw new CatalogBadRequestException("Nothing to update");
        }
        this.lock.lock();
        try {
            String newDescription;
            ObjectGroupDetails details = this.resolveDetails(objectGroupName);
            this.authorizer.authorizeObjectGroupAlter(principal, details.toSecurable());
            String newObjectGroupName = request.getGroupName() != null ? CatalogObjectNameValidation.VALIDATION_OBJECT_GROUP.normalizeObjectName(request.getGroupName().getValue()) : details.objectGroupName();
            String string = newDescription = request.getDescription() != null ? request.getDescription().getValue() : details.description();
            if (Objects.equals(newObjectGroupName, details.objectGroupName()) && Objects.equals(newDescription, details.description())) {
                return;
            }
            boolean updated = this.store.updateIfExists(details.objectGroupId(), newObjectGroupName, newDescription);
            if (!updated) {
                throw new CatalogObjectGroupDoesNotExistException(details.objectGroupName());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(AuthenticatedPrincipal principal, String objectGroupName) {
        this.lock.lock();
        try {
            ObjectGroupDetails details = this.resolveDetails(objectGroupName);
            this.authorizer.authorizeObjectGroupDrop(principal, details.toSecurable());
            boolean deleted = this.store.deleteIfExists(details.objectGroupId(), details.objectGroupName());
            if (!deleted) {
                throw new CatalogObjectGroupDoesNotExistException(details.objectGroupName());
            }
            this.privilegeInternalService.clearPrivileges();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean grantOwnership(AuthenticatedPrincipal principal, String objectGroupName, AuthenticatedPrincipal newOwnerPrincipal) {
        this.lock.lock();
        try {
            ObjectGroupDetails details = this.resolveDetails(objectGroupName);
            this.authorizer.authorizeGrantOwnership(principal, details.toSecurable());
            if (details.ownerId().equals(Optional.of(newOwnerPrincipal.id()))) {
                boolean bl = false;
                return bl;
            }
            boolean updated = this.store.updateOwnerIfExists(details.objectGroupId(), newOwnerPrincipal.id());
            if (!updated) {
                throw new CatalogObjectGroupDoesNotExistException(details.objectGroupName());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ObjectGroupInfo info(AuthenticatedPrincipal principal, String objectGroupName) {
        ObjectGroupDetails details = this.resolveDetails(objectGroupName);
        this.authorizer.authorizeObjectGroupDescribe(principal, details.toSecurable());
        return details.toInfo();
    }

    public ObjectGroupListResponse list(AuthenticatedPrincipal principal, ResultPage page) {
        AuthorizerObjectGroupPredicate authorizerPredicate = this.authorizer.authorizeObjectGroupList(principal);
        Predicate<ObjectGroupDetails> predicate = details -> authorizerPredicate.test(details.toSecurable());
        return this.store.list(page, predicate);
    }

    public ObjectGroupObjectListResponse listObjectsForApi(AuthenticatedPrincipal principal, String objectGroupName, Optional<UUID> itemId, Optional<String> objectType, ResultPage page) {
        Optional<CedrusDataIcebergObjectType> parsedObjectType = objectType.map(caption -> (CedrusDataIcebergObjectType)CedrusDataIcebergObjectType.parse((String)caption).orElseThrow(() -> new CatalogBadRequestException("Invalid object type: " + caption)));
        ObjectGroupDetails details = this.resolveDetails(objectGroupName);
        return this.listObjectsInternal(principal, details, itemId, parsedObjectType, page, (catalogName, result) -> new ObjectGroupObjectListResponse(result.items().stream().map(item -> item.toInfo((String)catalogName)).toList(), result.nextPageToken()));
    }

    public ObjectGroupObjectDetailsListResultForMaintenance listObjectsForMaintenance(AuthenticatedPrincipal principal, String objectGroupName, UUID objectGroupId, CedrusDataIcebergObjectType objectType, ResultPage page) {
        ObjectGroupDetails details = this.resolveDetails(objectGroupName, objectGroupId);
        return this.listObjectsInternal(principal, details, Optional.empty(), Optional.of(objectType), page, (catalogName, result) -> new ObjectGroupObjectDetailsListResultForMaintenance((String)catalogName, result.items().stream().map(item -> new MaintenanceOperationObject((String)catalogName, item.namespaceName(), item.objectName(), item.objectId())).toList(), result.nextPageToken()));
    }

    private <T> T listObjectsInternal(AuthenticatedPrincipal principal, ObjectGroupDetails objectGroupDetails, Optional<UUID> objectGroupItemId, Optional<CedrusDataIcebergObjectType> objectType, ResultPage page, BiFunction<String, ObjectGroupObjectDetailsListResult, T> converter) {
        return (T)this.catalogService.execute(principal, objectGroupDetails.catalogId(), objectGroupDetails.catalogName(), catalogContext -> {
            AuthorizerObjectPredicate authorizerPredicate = this.authorizer.authorizeObjectGroupListObjects(principal, objectGroupDetails.toSecurable());
            Predicate<ObjectGroupObjectDetails> predicate = info -> authorizerPredicate.test(info.toSecurable(catalogContext.toSecurable()));
            ObjectGroupObjectDetailsListResult result = this.store.listObjects(objectGroupDetails.objectGroupId(), objectType, objectGroupItemId, page, predicate);
            return converter.apply(objectGroupDetails.catalogName(), result);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(AuthenticatedPrincipal principal, String objectGroupName, ObjectGroupItemAddRequest request) {
        String normalizedObjectGroupName = CatalogObjectNameValidation.VALIDATION_OBJECT_GROUP.normalizeObjectName(objectGroupName);
        this.lock.lock();
        try {
            ObjectGroupDetails details = this.resolveDetails(normalizedObjectGroupName);
            this.authorizer.authorizeObjectGroupAlter(principal, details.toSecurable());
            this.catalogService.execute(principal, details.catalogId(), details.catalogName(), catalogContext -> {
                Optional<ObjectGroupTarget> target = this.resolveTarget((IcebergCatalogContext)catalogContext, request.getNamespaceName(), request.getObjectName());
                if (target.isEmpty()) {
                    throw new CatalogBadRequestException("Either namespace name or object name must be provided");
                }
                this.store.addItem(details.objectGroupId(), target.get());
                return null;
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteItem(AuthenticatedPrincipal principal, String objectGroupName, UUID itemId) {
        if (itemId == null) {
            throw new CatalogBadRequestException("Iceberg object group item ID cannot be empty");
        }
        this.lock.lock();
        try {
            ObjectGroupDetails details = this.resolveDetails(objectGroupName);
            this.authorizer.authorizeObjectGroupAlter(principal, details.toSecurable());
            boolean deleted = this.store.deleteItemIfExists(itemId);
            if (!deleted) {
                throw new CatalogObjectGroupItemDoesNotExistException(details.objectGroupName(), itemId.toString());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public ObjectGroupItemListResponse listItems(AuthenticatedPrincipal principal, String objectGroupName, ResultPage page) {
        ObjectGroupDetails details = this.resolveDetails(objectGroupName);
        this.authorizer.authorizeObjectGroupDescribe(principal, details.toSecurable());
        return this.store.listItems(details.objectGroupId(), page);
    }

    public UUID resolveIdForMaintenance(String objectGroupName) {
        return this.resolveDetails(objectGroupName).objectGroupId();
    }

    @VisibleForTesting
    public ObjectGroupDetails resolveDetails(String objectGroupName) {
        String normalizedObjectGroupName = CatalogObjectNameValidation.VALIDATION_OBJECT_GROUP.normalizeObjectName(objectGroupName);
        return this.store.details(normalizedObjectGroupName).orElseThrow(() -> new CatalogObjectGroupDoesNotExistException(normalizedObjectGroupName));
    }

    private ObjectGroupDetails resolveDetails(String objectGroupName, UUID objectGroupId) {
        String normalizedObjectGroupName = CatalogObjectNameValidation.VALIDATION_OBJECT_GROUP.normalizeObjectName(objectGroupName);
        return this.store.details(objectGroupId).orElseThrow(() -> new CatalogObjectGroupDoesNotExistException(normalizedObjectGroupName));
    }

    private Optional<ObjectGroupTarget> resolveTarget(IcebergCatalogContext catalogContext, String namespaceName, String objectName) {
        if (namespaceName == null) {
            if (objectName == null) {
                return Optional.empty();
            }
            throw new CatalogBadRequestException("Object name cannot be set when namespace name is not present");
        }
        if (ObjectGroupService.isWildcard(namespaceName)) {
            if (objectName == null || ObjectGroupService.isWildcard(objectName)) {
                return Optional.of(new ObjectGroupTarget(Optional.empty(), Optional.empty()));
            }
            throw new CatalogBadRequestException("Object name cannot be set when namespace name is wildcard");
        }
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        boolean hasObjectName = objectName != null && !ObjectGroupService.isWildcard(objectName);
        try {
            return this.namespaceService.execute(catalogContext, normalizedNamespaceName, namespaceContext -> {
                if (hasObjectName) {
                    String normalizedObjectName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(objectName);
                    IcebergObjectDetails objectDetails = this.tableService.details((IcebergNamespaceContext)namespaceContext, normalizedObjectName).orElseThrow(() -> new IcebergObjectDoesNotExistException(normalizedNamespaceName, normalizedObjectName));
                    return Optional.of(new ObjectGroupTarget(Optional.empty(), Optional.of(objectDetails.objectId())));
                }
                return Optional.of(new ObjectGroupTarget(Optional.of(namespaceContext.namespaceId()), Optional.empty()));
            });
        }
        catch (IcebergNamespaceDoesNotExistException e) {
            if (hasObjectName) {
                throw new IcebergObjectDoesNotExistException(normalizedNamespaceName, CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(objectName));
            }
            throw e;
        }
    }

    private static boolean isWildcard(String value) {
        return value != null && "*".equals(value.trim());
    }
}

