/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.objectgroup;

import java.util.Optional;
import java.util.UUID;
import ru.cedrusdata.catalog.core.security.authorization.securable.CatalogInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableItem;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.iceberg.CedrusDataIcebergObjectType;
import ru.cedrusdata.catalog.spi.model.ObjectGroupObjectInfo;

public record ObjectGroupObjectDetails(UUID namespaceId, String namespaceName, Optional<UUID> namespaceOwnerId, UUID objectId, String objectName, Optional<UUID> objectOwnerId, CedrusDataIcebergObjectType objectType) {
    public ObjectInternalSecurable toSecurable(CatalogInternalSecurable catalogSecurable) {
        SecurableType securableType = switch (this.objectType) {
            default -> throw new MatchException(null, null);
            case CedrusDataIcebergObjectType.TABLE -> SecurableType.SECURABLE_TYPE_TABLE;
            case CedrusDataIcebergObjectType.VIEW -> SecurableType.SECURABLE_TYPE_VIEW;
            case CedrusDataIcebergObjectType.CEDRUSDATA_MATERIALIZED_VIEW -> SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW;
        };
        return new ObjectInternalSecurable(securableType, catalogSecurable.catalog(), new SecurableItem(this.namespaceId, this.namespaceOwnerId, this.namespaceName), new SecurableItem(this.objectId, this.objectOwnerId, this.objectName));
    }

    public ObjectGroupObjectInfo toInfo(String catalogName) {
        return new ObjectGroupObjectInfo(catalogName, this.namespaceName, this.objectName, this.objectType.caption());
    }
}

