/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core;

import com.google.common.base.Verify;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import ru.cedrusdata.catalog.core.PageData;
import ru.cedrusdata.catalog.spi.client.ResultPage;

public class ResultPageIterator<T>
implements Iterator<T> {
    private final Function<ResultPage, PageData<T>> pageFunction;
    private final OptionalInt pageSize;
    private String nextPageToken;
    private Iterator<T> currentPageIterator;

    public ResultPageIterator(Function<ResultPage, PageData<T>> pageFunction, int pageSize) {
        Verify.verify((pageSize > 0 ? 1 : 0) != 0);
        this.pageFunction = pageFunction;
        this.pageSize = OptionalInt.of(pageSize);
    }

    @Override
    public boolean hasNext() {
        ResultPage nextPage;
        if (this.currentPageIterator == null) {
            nextPage = new ResultPage(Optional.empty(), this.pageSize);
        } else {
            if (this.currentPageIterator.hasNext()) {
                return true;
            }
            if (this.nextPageToken == null) {
                return false;
            }
            nextPage = new ResultPage(Optional.of(this.nextPageToken), this.pageSize);
        }
        PageData<T> pageData = this.pageFunction.apply(nextPage);
        this.nextPageToken = pageData.nextPageToken();
        this.currentPageIterator = pageData.pageData().iterator();
        return this.currentPageIterator.hasNext();
    }

    @Override
    public T next() {
        if (this.currentPageIterator == null) {
            throw new NoSuchElementException();
        }
        return this.currentPageIterator.next();
    }
}

