/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import org.weakref.jmx.guice.ExportBinder;
import ru.cedrusdata.catalog.CurrentTimeSupplier;
import ru.cedrusdata.catalog.config.CatalogCacheConfig;
import ru.cedrusdata.catalog.config.CatalogConfig;
import ru.cedrusdata.catalog.config.CatalogMaintenanceConfig;
import ru.cedrusdata.catalog.core.computeengine.ComputeEngineModule;
import ru.cedrusdata.catalog.core.filesystem.FileSystemService;
import ru.cedrusdata.catalog.core.i18n.InternationalizationService;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationService;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupService;
import ru.cedrusdata.catalog.core.principal.JwtTokenManager;
import ru.cedrusdata.catalog.core.principal.PrincipalRoleIdService;
import ru.cedrusdata.catalog.core.principal.PrincipalService;
import ru.cedrusdata.catalog.core.principal.cache.PrincipalServiceCache;
import ru.cedrusdata.catalog.core.resource.ResourceModule;
import ru.cedrusdata.catalog.core.security.audit.AuditManager;
import ru.cedrusdata.catalog.core.security.authorization.Authorizer;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeInternalService;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeService;
import ru.cedrusdata.catalog.core.security.authorization.SystemAuthorizer;
import ru.cedrusdata.catalog.core.security.authorization.SystemAuthorizerServices;
import ru.cedrusdata.catalog.core.security.authorization.SystemAuthorizerServicesImpl;
import ru.cedrusdata.catalog.core.security.provider.SecurityProviderService;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;

public class CoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogCacheConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogMaintenanceConfig.class);
        binder.install((Module)new ResourceModule());
        binder.bind(JwtTokenManager.class).in(Scopes.SINGLETON);
        binder.bind(SystemAuthorizerServices.class).to(SystemAuthorizerServicesImpl.class).in(Scopes.SINGLETON);
        binder.bind(Authorizer.class).to(SystemAuthorizer.class).in(Scopes.SINGLETON);
        binder.bind(AuditManager.class).in(Scopes.SINGLETON);
        binder.bind(CurrentTimeSupplier.class).in(Scopes.SINGLETON);
        binder.bind(PrincipalServiceCache.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(PrincipalServiceCache.class).withGeneratedName();
        binder.bind(PrincipalRoleIdService.class).in(Scopes.SINGLETON);
        binder.bind(PrincipalService.class).in(Scopes.SINGLETON);
        binder.bind(PrivilegeInternalService.class).in(Scopes.SINGLETON);
        binder.bind(PrivilegeService.class).in(Scopes.SINGLETON);
        binder.bind(FileSystemService.class).in(Scopes.SINGLETON);
        binder.bind(IcebergCatalogService.class).in(Scopes.SINGLETON);
        binder.bind(ObjectGroupService.class).in(Scopes.SINGLETON);
        binder.bind(SecurityProviderService.class).in(Scopes.SINGLETON);
        this.install(new ComputeEngineModule());
        binder.bind(MaintenanceOperationService.class).in(Scopes.SINGLETON);
        binder.bind(InternationalizationService.class).in(Scopes.SINGLETON);
    }
}

