/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core;

import io.airlift.log.Logger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractUsageAwareResource<T extends AutoCloseable> {
    private static final Logger log = Logger.get(AbstractUsageAwareResource.class);
    private final T resource;
    private final String name;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicInteger usageCounter = new AtomicInteger();
    private boolean closeRequested;

    public AbstractUsageAwareResource(T resource, String name) {
        this.resource = (AutoCloseable)Objects.requireNonNull(resource, "resource");
        this.name = Objects.requireNonNull(name, "name");
    }

    public String name() {
        return this.name;
    }

    public T resource() {
        return this.resource;
    }

    public void acquire() {
        this.lock.readLock().lock();
        try {
            if (this.closeRequested) {
                throw this.onStoppingException();
            }
            this.usageCounter.incrementAndGet();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void release() {
        boolean shouldClose = false;
        this.lock.readLock().lock();
        try {
            int val = this.usageCounter.decrementAndGet();
            if (this.closeRequested && val == 0) {
                shouldClose = true;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (shouldClose) {
            this.doClose();
        }
    }

    public void close() {
        boolean shouldClose = false;
        this.lock.writeLock().lock();
        try {
            if (!this.closeRequested) {
                this.closeRequested = true;
                if (this.usageCounter.get() == 0) {
                    shouldClose = true;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (shouldClose) {
            this.doClose();
        }
    }

    protected abstract RuntimeException onStoppingException();

    private void doClose() {
        try {
            this.resource.close();
        }
        catch (Throwable e) {
            log.warn(e, String.format("Exception when trying to close resource \"%s\"", this.name));
        }
    }
}

