/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.config;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;

public class CatalogMaintenanceConfig {
    private int maintenanceMaxActiveOperations = 100;
    private int maintenanceMaxOperationErrors = 5;
    private Duration maintenanceHistoryMaxAge = Duration.valueOf((String)"30d");
    private Duration maintenanceHistoryCleanupInterval = Duration.valueOf((String)"1m");

    @Min(value=1L)
    public @Min(value=1L) int getMaintenanceMaxActiveOperations() {
        return this.maintenanceMaxActiveOperations;
    }

    @Config(value="maintenance.max-active-operations")
    @ConfigDescription(value="Maximum number of concurrent active maintenance operations")
    public CatalogMaintenanceConfig setMaintenanceMaxActiveOperations(int maintenanceMaxActiveOperations) {
        this.maintenanceMaxActiveOperations = maintenanceMaxActiveOperations;
        return this;
    }

    @NotNull
    @MinDuration(value="1d")
    public @NotNull @MinDuration(value="1d") Duration getMaintenanceHistoryMaxAge() {
        return this.maintenanceHistoryMaxAge;
    }

    @Config(value="maintenance.history.max-age")
    @ConfigDescription(value="Maximum age of completed maintenance operations")
    public CatalogMaintenanceConfig setMaintenanceHistoryMaxAge(Duration maintenanceHistoryMaxAge) {
        this.maintenanceHistoryMaxAge = maintenanceHistoryMaxAge;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaintenanceMaxOperationErrors() {
        return this.maintenanceMaxOperationErrors;
    }

    @Config(value="maintenance.max-operation-errors")
    @ConfigDescription(value="Maximum number of errors allowed during the multi-object operation execution. After reaching this number, the operation will be automatically canceled.")
    public CatalogMaintenanceConfig setMaintenanceMaxOperationErrors(int maintenanceMaxOperationErrors) {
        this.maintenanceMaxOperationErrors = maintenanceMaxOperationErrors;
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public @NotNull @MinDuration(value="1s") Duration getMaintenanceHistoryCleanupInterval() {
        return this.maintenanceHistoryCleanupInterval;
    }

    @Config(value="maintenance.history.cleanup-interval")
    @ConfigDescription(value="How often to perform materialized CTE cleanup")
    public CatalogMaintenanceConfig setMaintenanceHistoryCleanupInterval(Duration maintenanceHistoryCleanupInterval) {
        this.maintenanceHistoryCleanupInterval = maintenanceHistoryCleanupInterval;
        return this;
    }
}

