/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.opentelemetry.api.trace.Tracer;
import java.util.Objects;
import java.util.Optional;
import ru.cedrusdata.catalog.api.ApiStats;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClient;
import ru.cedrusdata.catalog.api.IcebergApiStats;
import ru.cedrusdata.catalog.api.JmxEmbeddedInternalCatalogClient;
import ru.cedrusdata.catalog.api.TracingEmbeddedInternalCatalogClient;
import ru.cedrusdata.catalog.core.computeengine.ComputeEngineService;
import ru.cedrusdata.catalog.core.filesystem.FileSystemService;
import ru.cedrusdata.catalog.core.i18n.InternationalizationService;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationService;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupService;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.core.principal.PrincipalService;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeService;
import ru.cedrusdata.catalog.core.security.provider.SecurityProviderService;
import ru.cedrusdata.catalog.iceberg.InternalIcebergCatalogClient;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceService;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableService;
import ru.cedrusdata.catalog.server.ServerInitializationInfo;
import ru.cedrusdata.catalog.server.ServerVersion;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.tracing.TracingProvider;

public class EmbeddedInternalCatalogClientFactory {
    private final ServerVersion serverVersion;
    private final ServerInitializationInfo serverInitializationInfo;
    private final PrincipalService principalService;
    private final PrivilegeService privilegeService;
    private final FileSystemService fileSystemService;
    private final IcebergCatalogService icebergCatalogService;
    private final IcebergNamespaceService icebergNamespaceService;
    private final IcebergTableService icebergTableService;
    private final MaintenanceOperationService maintenanceOperationsService;
    private final ComputeEngineService computeEngineService;
    private final ObjectGroupService objectGroupService;
    private final InternationalizationService internationalizationService;
    private final SecurityProviderService securityProviderService;
    private final ApiStats apiStats;
    private final IcebergApiStats icebergApiStats;
    private final Optional<Tracer> tracer;

    @Inject
    public EmbeddedInternalCatalogClientFactory(ServerVersion serverVersion, ServerInitializationInfo serverInitializationInfo, PrincipalService principalService, PrivilegeService privilegeService, FileSystemService fileSystemService, IcebergCatalogService icebergCatalogService, IcebergNamespaceService icebergNamespaceService, IcebergTableService icebergTableService, MaintenanceOperationService maintenanceOperationsService, ComputeEngineService computeEngineService, ObjectGroupService objectGroupService, InternationalizationService internationalizationService, SecurityProviderService securityProviderService, ApiStats apiStats, IcebergApiStats icebergApiStats, TracingProvider tracingProvider) {
        this.serverVersion = Objects.requireNonNull(serverVersion, "serverVersion");
        this.serverInitializationInfo = Objects.requireNonNull(serverInitializationInfo, "serverInitializationInfo");
        this.principalService = Objects.requireNonNull(principalService, "principalService");
        this.privilegeService = Objects.requireNonNull(privilegeService, "privilegeService");
        this.fileSystemService = Objects.requireNonNull(fileSystemService, "fileSystemService");
        this.icebergCatalogService = Objects.requireNonNull(icebergCatalogService, "icebergCatalogService");
        this.icebergNamespaceService = Objects.requireNonNull(icebergNamespaceService, "icebergNamespaceService");
        this.icebergTableService = Objects.requireNonNull(icebergTableService, "icebergTableService");
        this.maintenanceOperationsService = Objects.requireNonNull(maintenanceOperationsService, "maintenanceOperationsService");
        this.computeEngineService = Objects.requireNonNull(computeEngineService, "computeEngineService");
        this.objectGroupService = Objects.requireNonNull(objectGroupService, "objectGroupService");
        this.internationalizationService = Objects.requireNonNull(internationalizationService, "internationalizationService");
        this.securityProviderService = Objects.requireNonNull(securityProviderService, "securityPluginService");
        this.apiStats = Objects.requireNonNull(apiStats, "apiStats");
        this.icebergApiStats = Objects.requireNonNull(icebergApiStats, "icebergApiStats");
        this.tracer = Objects.requireNonNull(tracingProvider, "tracingProvider").tracerForApi();
    }

    public InternalCatalogClient createClient(AuthenticationContext context) {
        JmxEmbeddedInternalCatalogClient client = this.createJmxClient(context);
        return this.tracer.isPresent() ? new TracingEmbeddedInternalCatalogClient(client, this.tracer.get()) : client;
    }

    public InternalIcebergCatalogClient createIcebergClient(AuthenticationContext context) {
        JmxEmbeddedInternalCatalogClient client = this.createJmxClient(context);
        return this.tracer.isPresent() ? new TracingEmbeddedInternalCatalogClient(client, this.tracer.get()) : client;
    }

    @VisibleForTesting
    public JmxEmbeddedInternalCatalogClient createJmxClient(AuthenticationContext context) {
        return new JmxEmbeddedInternalCatalogClient(this.createEmbeddedClient(context), this.apiStats, this.icebergApiStats);
    }

    @VisibleForTesting
    public EmbeddedInternalCatalogClient createEmbeddedClient(AuthenticationContext context) {
        return new EmbeddedInternalCatalogClient(context, this.serverVersion, this.serverInitializationInfo, this.principalService, this.privilegeService, this.fileSystemService, this.icebergCatalogService, this.icebergNamespaceService, this.icebergTableService, this.objectGroupService, this.maintenanceOperationsService, this.computeEngineService, this.internationalizationService, this.securityProviderService);
    }
}

