/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.rls;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ChannelLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ConnectivityState;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancerRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ObjectPool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.rls.ChildLoadBalancerHelper;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.rls.ResolvedAddressFactory;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.rls.RlsProtoData;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.util.ForwardingLoadBalancerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

final class LbPolicyConfiguration {
    private final RlsProtoData.RouteLookupConfig routeLookupConfig;
    @Nullable
    private final Map<String, ?> routeLookupChannelServiceConfig;
    private final ChildLoadBalancingPolicy policy;

    LbPolicyConfiguration(RlsProtoData.RouteLookupConfig routeLookupConfig, @Nullable Map<String, ?> routeLookupChannelServiceConfig, ChildLoadBalancingPolicy policy) {
        this.routeLookupConfig = Preconditions.checkNotNull(routeLookupConfig, "routeLookupConfig");
        this.routeLookupChannelServiceConfig = routeLookupChannelServiceConfig;
        this.policy = Preconditions.checkNotNull(policy, "policy");
    }

    RlsProtoData.RouteLookupConfig getRouteLookupConfig() {
        return this.routeLookupConfig;
    }

    @Nullable
    Map<String, ?> getRouteLookupChannelServiceConfig() {
        return this.routeLookupChannelServiceConfig;
    }

    ChildLoadBalancingPolicy getLoadBalancingPolicy() {
        return this.policy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LbPolicyConfiguration that = (LbPolicyConfiguration)o;
        return Objects.equals(this.routeLookupConfig, that.routeLookupConfig) && Objects.equals(this.routeLookupChannelServiceConfig, that.routeLookupChannelServiceConfig) && Objects.equals(this.policy, that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.routeLookupConfig, this.routeLookupChannelServiceConfig, this.policy);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("routeLookupConfig", this.routeLookupConfig).add("routeLookupChannelServiceConfig", this.routeLookupChannelServiceConfig).add("policy", this.policy).toString();
    }

    static final class InvalidChildPolicyConfigException
    extends Exception {
        private static final long serialVersionUID = 0L;

        InvalidChildPolicyConfigException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class RefCountedChildPolicyWrapper
    implements ObjectPool<ChildPolicyWrapper> {
        private final AtomicLong refCnt = new AtomicLong();
        @Nullable
        private ChildPolicyWrapper childPolicyWrapper;

        private RefCountedChildPolicyWrapper(ChildPolicyWrapper childPolicyWrapper) {
            this.childPolicyWrapper = Preconditions.checkNotNull(childPolicyWrapper, "childPolicyWrapper");
        }

        @Override
        public ChildPolicyWrapper getObject() {
            Preconditions.checkState(!this.isReleased(), "ChildPolicyWrapper is already released");
            this.refCnt.getAndIncrement();
            return this.childPolicyWrapper;
        }

        @Override
        @Nullable
        public ChildPolicyWrapper returnObject(Object object) {
            Preconditions.checkState(!this.isReleased(), "cannot return already released ChildPolicyWrapper, this is possibly a bug.");
            Preconditions.checkState(this.childPolicyWrapper == object, "returned object doesn't match the pooled childPolicyWrapper");
            long newCnt = this.refCnt.decrementAndGet();
            Preconditions.checkState(newCnt != -1L, "Cannot return never pooled childPolicyWrapper");
            if (newCnt == 0L) {
                this.childPolicyWrapper.shutdown();
                this.childPolicyWrapper = null;
            }
            return null;
        }

        boolean isReleased() {
            return this.childPolicyWrapper == null;
        }

        static RefCountedChildPolicyWrapper of(ChildPolicyWrapper childPolicyWrapper) {
            return new RefCountedChildPolicyWrapper(childPolicyWrapper);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("object", this.childPolicyWrapper).add("refCnt", this.refCnt.get()).toString();
        }
    }

    static interface ChildLbStatusListener {
        public void onStatusChanged(ConnectivityState var1);
    }

    static final class ChildPolicyWrapper {
        private final String target;
        private final ChildPolicyReportingHelper helper;
        private final LoadBalancer lb;
        private volatile LoadBalancer.SubchannelPicker picker;
        private ConnectivityState state;

        public ChildPolicyWrapper(String target, ChildLoadBalancingPolicy childPolicy, final ResolvedAddressFactory childLbResolvedAddressFactory, ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider, ChildLbStatusListener childLbStatusListener) {
            this.target = target;
            this.helper = new ChildPolicyReportingHelper(childLbHelperProvider, childLbStatusListener);
            LoadBalancerProvider lbProvider = childPolicy.getEffectiveLbProvider();
            final NameResolver.ConfigOrError lbConfig = lbProvider.parseLoadBalancingPolicyConfig(childPolicy.getEffectiveChildPolicy(target));
            this.lb = lbProvider.newLoadBalancer(this.helper);
            this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.DEBUG, "RLS child lb created. config: {0}", lbConfig.getConfig());
            this.helper.getSynchronizationContext().execute(new Runnable(){

                @Override
                public void run() {
                    if (!lb.acceptResolvedAddresses(childLbResolvedAddressFactory.create(lbConfig.getConfig())).isOk()) {
                        helper.refreshNameResolution();
                    }
                    lb.requestConnection();
                }
            });
        }

        String getTarget() {
            return this.target;
        }

        LoadBalancer.SubchannelPicker getPicker() {
            return this.picker;
        }

        ChildPolicyReportingHelper getHelper() {
            return this.helper;
        }

        public ConnectivityState getState() {
            return this.state;
        }

        void refreshState() {
            this.helper.getSynchronizationContext().execute(new Runnable(){

                @Override
                public void run() {
                    helper.updateBalancingState(state, picker);
                }
            });
        }

        void shutdown() {
            this.helper.getSynchronizationContext().execute(new Runnable(){

                @Override
                public void run() {
                    lb.shutdown();
                }
            });
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("target", this.target).add("picker", this.picker).add("state", (Object)this.state).toString();
        }

        final class ChildPolicyReportingHelper
        extends ForwardingLoadBalancerHelper {
            private final ChildLoadBalancerHelper delegate;
            private final ChildLbStatusListener listener;

            ChildPolicyReportingHelper(ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childHelperProvider, ChildLbStatusListener listener) {
                Preconditions.checkNotNull(childHelperProvider, "childHelperProvider");
                this.delegate = childHelperProvider.forTarget(ChildPolicyWrapper.this.getTarget());
                this.listener = Preconditions.checkNotNull(listener, "listener");
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return this.delegate;
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                ChildPolicyWrapper.this.picker = newPicker;
                ChildPolicyWrapper.this.state = newState;
                super.updateBalancingState(newState, newPicker);
                this.listener.onStatusChanged(newState);
            }
        }
    }

    static final class RefCountedChildPolicyWrapperFactory {
        @VisibleForTesting
        final Map<String, RefCountedChildPolicyWrapper> childPolicyMap = new HashMap<String, RefCountedChildPolicyWrapper>();
        private final ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider;
        private final ChildLbStatusListener childLbStatusListener;
        private final ChildLoadBalancingPolicy childPolicy;
        private final ResolvedAddressFactory childLbResolvedAddressFactory;

        public RefCountedChildPolicyWrapperFactory(ChildLoadBalancingPolicy childPolicy, ResolvedAddressFactory childLbResolvedAddressFactory, ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider, ChildLbStatusListener childLbStatusListener) {
            this.childPolicy = Preconditions.checkNotNull(childPolicy, "childPolicy");
            this.childLbResolvedAddressFactory = Preconditions.checkNotNull(childLbResolvedAddressFactory, "childLbResolvedAddressFactory");
            this.childLbHelperProvider = Preconditions.checkNotNull(childLbHelperProvider, "childLbHelperProvider");
            this.childLbStatusListener = Preconditions.checkNotNull(childLbStatusListener, "childLbStatusListener");
        }

        ChildPolicyWrapper createOrGet(String target) {
            RefCountedChildPolicyWrapper pooledChildPolicyWrapper = this.childPolicyMap.get(target);
            if (pooledChildPolicyWrapper == null) {
                ChildPolicyWrapper childPolicyWrapper = new ChildPolicyWrapper(target, this.childPolicy, this.childLbResolvedAddressFactory, this.childLbHelperProvider, this.childLbStatusListener);
                pooledChildPolicyWrapper = RefCountedChildPolicyWrapper.of(childPolicyWrapper);
                this.childPolicyMap.put(target, pooledChildPolicyWrapper);
                return pooledChildPolicyWrapper.getObject();
            }
            ChildPolicyWrapper childPolicyWrapper = pooledChildPolicyWrapper.getObject();
            if (childPolicyWrapper.getPicker() != null) {
                childPolicyWrapper.refreshState();
            }
            return childPolicyWrapper;
        }

        List<ChildPolicyWrapper> createOrGet(List<String> targets) {
            ArrayList<ChildPolicyWrapper> retVal = new ArrayList<ChildPolicyWrapper>();
            for (String target : targets) {
                retVal.add(this.createOrGet(target));
            }
            return retVal;
        }

        void release(ChildPolicyWrapper childPolicyWrapper) {
            Preconditions.checkNotNull(childPolicyWrapper, "childPolicyWrapper");
            String target = childPolicyWrapper.getTarget();
            RefCountedChildPolicyWrapper existing = this.childPolicyMap.get(target);
            Preconditions.checkState(existing != null, "Cannot access already released object");
            existing.returnObject(childPolicyWrapper);
            if (existing.isReleased()) {
                this.childPolicyMap.remove(target);
            }
        }
    }

    static final class ChildLoadBalancingPolicy {
        private final Map<String, Object> effectiveRawChildPolicy;
        private final LoadBalancerProvider effectiveLbProvider;
        private final String targetFieldName;

        @VisibleForTesting
        ChildLoadBalancingPolicy(String targetFieldName, Map<String, Object> effectiveRawChildPolicy, LoadBalancerProvider effectiveLbProvider) {
            Preconditions.checkArgument(targetFieldName != null && !targetFieldName.isEmpty(), "targetFieldName cannot be empty or null");
            this.targetFieldName = targetFieldName;
            this.effectiveRawChildPolicy = Preconditions.checkNotNull(effectiveRawChildPolicy, "effectiveRawChildPolicy");
            this.effectiveLbProvider = Preconditions.checkNotNull(effectiveLbProvider, "effectiveLbProvider");
        }

        static ChildLoadBalancingPolicy create(String childPolicyConfigTargetFieldName, List<Map<String, ?>> childPolicies) throws InvalidChildPolicyConfigException {
            Map<String, ?> effectiveChildPolicy = null;
            LoadBalancerProvider effectiveLbProvider = null;
            ArrayList<String> policyTried = new ArrayList<String>();
            LoadBalancerRegistry lbRegistry = LoadBalancerRegistry.getDefaultRegistry();
            for (Map<String, ?> childPolicy : childPolicies) {
                if (childPolicy.isEmpty()) continue;
                if (childPolicy.size() != 1) {
                    throw new InvalidChildPolicyConfigException("childPolicy should have exactly one loadbalancing policy");
                }
                String policyName = childPolicy.keySet().iterator().next();
                LoadBalancerProvider provider = lbRegistry.getProvider(policyName);
                if (provider != null) {
                    effectiveLbProvider = provider;
                    effectiveChildPolicy = Collections.unmodifiableMap(childPolicy);
                    break;
                }
                policyTried.add(policyName);
            }
            if (effectiveChildPolicy == null) {
                throw new InvalidChildPolicyConfigException(String.format("no valid childPolicy found, policy tried: %s", policyTried));
            }
            return new ChildLoadBalancingPolicy(childPolicyConfigTargetFieldName, (Map)effectiveChildPolicy.values().iterator().next(), effectiveLbProvider);
        }

        Map<String, ?> getEffectiveChildPolicy(String target) {
            HashMap<String, Object> childPolicy = new HashMap<String, Object>(this.effectiveRawChildPolicy);
            childPolicy.put(this.targetFieldName, target);
            return childPolicy;
        }

        LoadBalancerProvider getEffectiveLbProvider() {
            return this.effectiveLbProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildLoadBalancingPolicy that = (ChildLoadBalancingPolicy)o;
            return Objects.equals(this.effectiveRawChildPolicy, that.effectiveRawChildPolicy) && Objects.equals(this.effectiveLbProvider, that.effectiveLbProvider) && Objects.equals(this.targetFieldName, that.targetFieldName);
        }

        public int hashCode() {
            return Objects.hash(this.effectiveRawChildPolicy, this.effectiveLbProvider, this.targetFieldName);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("effectiveRawChildPolicy", this.effectiveRawChildPolicy).add("effectiveLbProvider", this.effectiveLbProvider).add("childPolicyConfigTargetFieldName", this.targetFieldName).toString();
        }
    }
}

