/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.base.security.AnyCatalogPermissionsRule;
import io.trino.plugin.base.security.AnyCatalogSchemaPermissionsRule;
import io.trino.plugin.base.security.ProcedureAccessControlRule;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class CatalogProcedureAccessControlRule {
    public static final CatalogProcedureAccessControlRule ALLOW_BUILTIN = new CatalogProcedureAccessControlRule((Set<ProcedureAccessControlRule.ProcedurePrivilege>)ImmutableSet.of((Object)((Object)ProcedureAccessControlRule.ProcedurePrivilege.EXECUTE), (Object)((Object)ProcedureAccessControlRule.ProcedurePrivilege.GRANT_EXECUTE)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(Pattern.compile("system")), Optional.of(Pattern.compile("builtin")), Optional.empty());
    private final Optional<Pattern> catalogRegex;
    private final ProcedureAccessControlRule procedureAccessControlRule;

    @JsonCreator
    public CatalogProcedureAccessControlRule(@JsonProperty(value="privileges") Set<ProcedureAccessControlRule.ProcedurePrivilege> privileges, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="role") Optional<Pattern> roleRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="catalog") Optional<Pattern> catalogRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex, @JsonProperty(value="procedure") Optional<Pattern> procedureRegex) {
        this(catalogRegex, new ProcedureAccessControlRule(privileges, userRegex, roleRegex, groupRegex, schemaRegex, procedureRegex));
    }

    private CatalogProcedureAccessControlRule(Optional<Pattern> catalogRegex, ProcedureAccessControlRule procedureAccessControlRule) {
        this.catalogRegex = Objects.requireNonNull(catalogRegex, "catalogRegex is null");
        this.procedureAccessControlRule = Objects.requireNonNull(procedureAccessControlRule, "procedureAccessControlRule is null");
    }

    public boolean matches(String user, Set<String> roles, Set<String> groups, CatalogSchemaRoutineName procedureName) {
        if (!this.catalogRegex.map(regex -> regex.matcher(procedureName.getCatalogName()).matches()).orElse(true).booleanValue()) {
            return false;
        }
        return this.procedureAccessControlRule.matches(user, roles, groups, procedureName.getSchemaRoutineName());
    }

    Optional<AnyCatalogPermissionsRule> toAnyCatalogPermissionsRule() {
        if (this.procedureAccessControlRule.getPrivileges().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AnyCatalogPermissionsRule(this.procedureAccessControlRule.getUserRegex(), this.procedureAccessControlRule.getRoleRegex(), this.procedureAccessControlRule.getGroupRegex(), this.catalogRegex));
    }

    Optional<AnyCatalogSchemaPermissionsRule> toAnyCatalogSchemaPermissionsRule() {
        if (this.procedureAccessControlRule.getPrivileges().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AnyCatalogSchemaPermissionsRule(this.procedureAccessControlRule.getUserRegex(), this.procedureAccessControlRule.getRoleRegex(), this.procedureAccessControlRule.getGroupRegex(), this.catalogRegex, this.procedureAccessControlRule.getSchemaRegex()));
    }

    public boolean canExecuteProcedure() {
        return this.procedureAccessControlRule.canExecuteProcedure();
    }

    public boolean canGrantExecuteProcedure() {
        return this.procedureAccessControlRule.canGrantExecuteProcedure();
    }
}

