/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.DoNotCall;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.stats.TDigest;
import io.trino.spi.metrics.Distribution;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class TDigestHistogram
implements Distribution<TDigestHistogram> {
    private final TDigest digest;

    public static TDigestHistogram fromValue(double value) {
        return TDigestHistogram.fromValue(value, 1.0);
    }

    public static TDigestHistogram fromValue(double value, double weight) {
        TDigest digest = new TDigest();
        digest.add(value, weight);
        return new TDigestHistogram(digest);
    }

    public TDigestHistogram(TDigest digest) {
        this.digest = digest;
    }

    public synchronized TDigest getDigest() {
        return TDigest.copyOf((TDigest)this.digest);
    }

    @JsonProperty(value="digest")
    public synchronized byte[] serialize() {
        return this.digest.serialize().getBytes();
    }

    @JsonCreator
    @DoNotCall
    public static TDigestHistogram deserialize(@JsonProperty(value="digest") byte[] digest) {
        return new TDigestHistogram(TDigest.deserialize((Slice)Slices.wrappedBuffer((byte[])digest)));
    }

    public TDigestHistogram mergeWith(TDigestHistogram other) {
        TDigest result = this.getDigest();
        other.mergeTo(result);
        return new TDigestHistogram(result);
    }

    public TDigestHistogram mergeWith(List<TDigestHistogram> others) {
        if (others.isEmpty()) {
            return this;
        }
        TDigest result = this.getDigest();
        for (TDigestHistogram other : others) {
            other.mergeTo(result);
        }
        return new TDigestHistogram(result);
    }

    private synchronized void mergeTo(TDigest digest) {
        digest.mergeWith(this.digest);
    }

    @JsonProperty
    public synchronized long getTotal() {
        return (long)this.digest.getCount();
    }

    @JsonProperty
    public synchronized double getMin() {
        return this.digest.getMin();
    }

    @JsonProperty
    public synchronized double getMax() {
        return this.digest.getMax();
    }

    @JsonProperty
    public synchronized double getP01() {
        return this.digest.valueAt(0.01);
    }

    @JsonProperty
    public synchronized double getP05() {
        return this.digest.valueAt(0.05);
    }

    @JsonProperty
    public synchronized double getP10() {
        return this.digest.valueAt(0.1);
    }

    @JsonProperty
    public synchronized double getP25() {
        return this.digest.valueAt(0.25);
    }

    @JsonProperty
    public synchronized double getP50() {
        return this.digest.valueAt(0.5);
    }

    @JsonProperty
    public synchronized double getP75() {
        return this.digest.valueAt(0.75);
    }

    @JsonProperty
    public synchronized double getP90() {
        return this.digest.valueAt(0.9);
    }

    @JsonProperty
    public synchronized double getP95() {
        return this.digest.valueAt(0.95);
    }

    @JsonProperty
    public synchronized double getP99() {
        return this.digest.valueAt(0.99);
    }

    public synchronized double getPercentile(double percentile) {
        return this.digest.valueAt(percentile / 100.0);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"").add("count", this.getTotal()).add("p01", (Object)TDigestHistogram.formatDouble(this.getP01())).add("p05", (Object)TDigestHistogram.formatDouble(this.getP05())).add("p10", (Object)TDigestHistogram.formatDouble(this.getP10())).add("p25", (Object)TDigestHistogram.formatDouble(this.getP25())).add("p50", (Object)TDigestHistogram.formatDouble(this.getP50())).add("p75", (Object)TDigestHistogram.formatDouble(this.getP75())).add("p90", (Object)TDigestHistogram.formatDouble(this.getP90())).add("p95", (Object)TDigestHistogram.formatDouble(this.getP95())).add("p99", (Object)TDigestHistogram.formatDouble(this.getP99())).add("min", (Object)TDigestHistogram.formatDouble(this.getMin())).add("max", (Object)TDigestHistogram.formatDouble(this.getMax()));
        return helper.toString();
    }

    public static Optional<TDigestHistogram> merge(List<TDigestHistogram> histograms) {
        if (histograms.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(histograms.get(0).mergeWith((List)histograms.subList(1, histograms.size())));
    }

    private static String formatDouble(double value) {
        return String.format(Locale.US, "%.2f", value);
    }
}

