/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.openmetrics.types;

import io.airlift.openmetrics.types.Metric;
import io.airlift.stats.CounterStat;
import java.util.Map;
import java.util.Objects;

public record Counter(String metricName, long value, Map<String, String> labels, String help) implements Metric
{
    public Counter(String metricName, long value, Map<String, String> labels, String help) {
        this.metricName = Objects.requireNonNull(metricName, "metricName is null");
        this.value = value;
        this.labels = labels;
        this.help = help;
    }

    public static Counter from(String metricName, CounterStat counterStat, Map<String, String> labels, String help) {
        return new Counter(metricName, counterStat.getTotalCount(), labels, help);
    }

    @Override
    public String getMetricExposition() {
        return Metric.formatSingleValuedMetric(this.metricName, "counter", this.help, this.labels, Long.toString(this.value));
    }
}

